#ifndef _gl_particle
#define _gl_particle

double __frame_time;
class p_attribute { public:
  double r, g, b, alpha, radius;
};

class particle_type { public:
  double x, y, x_initial, y_initial, xvel, yvel, xaccel, yaccel;
  p_attribute initial, final, current;
  double start_time, life;
  BITMAP *image;
  particle_type *next, *prev;
  int update() {
    if (__frame_time > start_time + life) { return 0; }
    double t = __frame_time - start_time;
    x = 0.5 * xaccel * t * t + xvel * t + x_initial;
    y = 0.5 * yaccel * t * t + yvel * t + y_initial;
    double v = t / (life ? life: 1.0), u = 1 - v;
    current.r      = fabs( u * initial.r      + v * final.r      );
    current.g      = fabs( u * initial.g      + v * final.g      );
    current.b      = fabs( u * initial.b      + v * final.b      );
    current.alpha  = fabs( u * initial.alpha  + v * final.alpha  );
    current.radius = fabs( u * initial.radius + v * final.radius );
    return 1;
  }
};

particle_type *__first = 0;
int __particle_count = 0;
double view_x1, view_y1, view_xscale, view_yscale;

void add_particle(double x, double y, double xvel, double yvel, double xaccel, double yaccel,
                  double r1, double g1, double b1, double alpha1, double radius1,
                  double r2, double g2, double b2, double alpha2, double radius2,
                  double life, BITMAP *image) {
  if (!image || image->w <= 0 || image->h <= 0 || life < 0) { return; }
  texture_bitmap(image);
  __particle_count++;
  particle_type *current = new particle_type;
  current->prev = 0;
  current->next = __first;
  if (__first) { __first->prev = current; }
  __first = current;
  current->x_initial = x;
  current->y_initial = y;
  current->xvel = xvel;
  current->yvel = yvel;
  current->xaccel = xaccel;
  current->yaccel = yaccel;
  current->initial.r = r1;
  current->initial.g = g1;
  current->initial.b = b1;
  current->initial.alpha = alpha1;
  current->initial.radius = radius1;
  current->final.r = r2;
  current->final.g = g2;
  current->final.b = b2;
  current->final.alpha = alpha2;
  current->final.radius = radius2;
  current->start_time = __frame_time;
  current->life = life;
  current->image = image;
  current->current.r      = fabs(current->initial.r);
  current->current.g      = fabs(current->initial.g);
  current->current.b      = fabs(current->initial.b);
  current->current.alpha  = fabs(current->initial.alpha);
  current->current.radius = fabs(current->initial.radius);
}

void render_particle(BITMAP *bmp, BITMAP *img, int x1, int y1, int x2, int y2, int red, int green, int blue, int alpha) {
  int dx = ((img->w) << 16) / (x2 - x1);
  int dy = ((img->h) << 16) / (y2 - y1);
  int x1src = 0, y1src = 0;
  if (x1 < 0) { x1src = dx * -x1; x1 = 0; }
  if (y1 < 0) { y1src = dy * -y1; y1 = 0; }
  if (x2 > bmp->w) { x2 = bmp->w; }
  if (y2 > bmp->h) { y2 = bmp->h; }
  if (x1 >= x2) { return; }
  if (y1 >= y2) { return; }
  int bmul = red * alpha / 256;
  int gmul = green * alpha / 256;
  int rmul = blue * alpha / 256;
  int rval, gval, bval;
  int depth = bitmap_color_depth(bmp);
  if (depth == 16) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol16(srcline, xsrc >> 16);
        if (!(c2 & ~u_makecol16(1, 1, 1))) { continue; }
        int c1 = u_readcol16(dstline, x);
        rval = u_getr16(c1) + (u_getr16(c2) * rmul >> 8);
        gval = u_getg16(c1) + (u_getg16(c2) * gmul >> 8);
        bval = u_getb16(c1) + (u_getb16(c2) * bmul >> 8);
        if (rval & (~u_rmax16)) { rval = u_rmax16; }
        if (gval & (~u_gmax16)) { gval = u_gmax16; }
        if (bval & (~u_bmax16)) { bval = u_bmax16; }
        u_writecol16(dstline, x, u_makecol16(rval, gval, bval));
      }
    }
  } else if (depth == 24) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol24(srcline, xsrc >> 16);
        if (!(c2 & ~u_makecol24(4, 4, 4))) { continue; }
        int c1 = u_readcol24(dstline, x);
        rval = u_getr24(c1) + (u_getr24(c2) * rmul >> 8);
        gval = u_getg24(c1) + (u_getg24(c2) * gmul >> 8);
        bval = u_getb24(c1) + (u_getb24(c2) * bmul >> 8);
        if (rval & (~u_rmax24)) { rval = u_rmax24; }
        if (gval & (~u_gmax24)) { gval = u_gmax24; }
        if (bval & (~u_bmax24)) { bval = u_bmax24; }
        u_writecol24(dstline, x, u_makecol24(rval, gval, bval));
      }
    }
  } else if (depth == 32) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol32(srcline, xsrc >> 16);
        if (!(c2 & (~u_makecol24(4, 4, 4) & 0xFFFFFF))) { continue; }
        int c1 = u_readcol32(dstline, x);
        rval = u_getr32(c1) + (u_getr32(c2) * rmul >> 8);
        gval = u_getg32(c1) + (u_getg32(c2) * gmul >> 8);
        bval = u_getb32(c1) + (u_getb32(c2) * bmul >> 8);
        if (rval & (~u_rmax32)) { rval = u_rmax32; }
        if (gval & (~u_gmax32)) { gval = u_gmax32; }
        if (bval & (~u_bmax32)) { bval = u_bmax32; }
        u_writecol32(dstline, x, u_makecol32(rval, gval, bval));
      }
    }
  }
}

void gl_render_particle(BITMAP *bmp, BITMAP *img, int x1, int y1, int x2, int y2, int red, int green, int blue, int alpha) {
  glBindTexture(GL_TEXTURE_2D, img->texture);
  glColor4f(red*(1/255.0), green*(1/255.0), blue*(1/255.0), alpha*(1/255.0));

  glBegin(GL_QUADS);
    glTexCoord2d(0, 0);                 glVertex2f(x1, y1);
    glTexCoord2d(img->xtex, 0);         glVertex2f(x2, y1);
    glTexCoord2d(img->xtex, img->ytex); glVertex2f(x2, y2);
    glTexCoord2d(0, img->ytex);         glVertex2f(x1, y2);
  glEnd();

}

void draw_particles_caller(BITMAP *bmp, double x1, double y1, double x2, double y2, void (*cb)(BITMAP *, BITMAP *, int, int, int, int, int, int, int, int)) {
  if (!x1 && !x2 && !y1 && !y2) { x2 = bmp->w; y2 = bmp->h; }
  if (x1 == x2 || y1 == y2) { return; }
  view_x1 = x1;
  view_y1 = y1;
  view_xscale = bmp->w / (x2 - x1);
  view_yscale = bmp->h / (y2 - y1);
  particle_type *current = __first;
  while (current) {
    particle_type *next = current->next;
    if (current->update()) {
      double rad = current->current.radius * view_xscale;
      double px = (current->x - view_x1) * view_xscale;
      double py = (current->y - view_y1) * view_yscale;
      double aspect = double(current->image->h) / current->image->w;
      int x1 = int(px - rad), y1 = int(py - rad * aspect);
      int x2 = int(px + rad), y2 = int(py + rad * aspect);
      if (x2 > x1 && y2 > y1) {
        cb(bmp, current->image, x1, y1, x2, y2, int(current->current.r), int(current->current.g), int(current->current.b), int(current->current.alpha));
      }
    } else {
      if (current->next) { current->next->prev = current->prev; }
      if (current->prev) { current->prev->next = current->next; }
      if (current == __first) { __first = next; }
      delete current;
      __particle_count--;
    }
    current = next;
  }
  __frame_time = __timer_func();
}

void draw_particles(BITMAP *bmp, double x1=0, double y1=0, double x2=0, double y2=0) {
  modified_bitmap(bmp);
  draw_particles_caller(bmp, x1, y1, x2, y2, &render_particle);
}

void draw_particles(screen_type *scr, double x1=0, double y1=0, double x2=0, double y2=0) {
  glDisable(GL_DITHER);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  glShadeModel(GL_FLAT);
  BITMAP *bmp = new BITMAP;
  bmp->w = scr->w;
  bmp->h = scr->h;
  draw_particles_caller(bmp, x1, y1, x2, y2, &gl_render_particle);
  delete bmp;
}

int particle_count() { return __particle_count; }

#endif
