#ifndef _global_h
#define _global_h

#include <stdio.h>
#include <stdarg.h>
#include <math.h>

typedef double real;

void die(char *fmt, ...);

int file_exists(char *fname) {
  FILE *f = fopen(fname, "r"); if (!f) { return 0; }
  if (ferror(f) || feof(f)) { fclose(f); return 0; } fclose(f); return 1;
}
BITMAP *load_image(char *filename) {
  RGB pal[256];
  if (!file_exists(filename)) { die("Couldn't load resource: '%s'", filename); }
  BITMAP *result = load_bmp(filename, pal);
  if (!result) { die("Not enough memory for resource: '%s'", filename); }
  return result;
}
BITMAP *create_image(int w, int h) {
  BITMAP *result = create_bitmap(w, h);
  if (!result) { die("Not enough memory for internal bitmap: %dx%d", w, h); }
  return result;
}
BITMAP *create_image_ex(int depth, int w, int h) {
  BITMAP *result = create_bitmap_ex(depth, w, h);
  if (!result) { die("Not enough memory for internal bitmap: %dx%dx%d", w, h, depth); }
  return result; 
}
SAMPLE *load_sound(char *filename) {
  if (!file_exists(filename)) { die("Couldn't load resource: '%s'", filename); }
  SAMPLE *result = load_wav(filename);
  if (!result) { die("Not enough memory for resource: '%s'", filename); }
  return result;
}

void clip(real &val, real min, real max) { if (val < min) { val = min; } else if (val > max) { val = max; } }
void clip(int &val, int min, int max) { if (val < min) { val = min; } else if (val > max) { val = max; } }
void decay(real &val, real amount) { if (val < 0) { val += amount; if (val > 0) { val = 0; } } else if (val > 0) { val -= amount; if (val < 0) { val = 0; } } }
void decay_angle(real &a1, real a2, real amount) {
  a1 = a1 - floor(a1);
  a2 = a2 - floor(a2);
  real delta = a2 - a1;
  if (delta < .5 && delta > -.5) {
    if (delta > 0) { a1 += amount; if (a1 > a2) { a1 = a2; } }
    else { a1 -= amount; if (a1 < a2) { a1 = a2; } }
  } else {
    if (delta > 0) { a1 -= amount; if (a1 > a2 && (a1-floor(a1)) < a2) { a1 = a2; } }
    else { a1 += amount; if (a1 < a2 && (a1-floor(a1)) > a2) { a1 = a2; } }
  }
}
//void decay(real &val, real amount, real central=0) { if (val < central) { val += amount; if (val > central) { val = central; } } else if (val > central) { val -= amount; if (val < central) { val = central; } } }
void normalize(real &x, real &y) { real dist = sqrt(x * x + y * y); if (dist) { dist = 1.0 / dist; x *= dist; y *= dist; } }
template<class base> void swap(base &a, base &b) { base temp = a; a = b; b = temp; }

#endif
