#ifndef __object_h
#define __object_h

#include <string.h>
#include <math.h>
#ifndef M_PI
#define M_PI		3.14159265358979323846
#endif

real frame_time, dt;
real xcamera, ycamera;
int default_antialias = 0;

int toScreenX(real x) { return int((x - xcamera) * buffer->h + buffer->w * 0.5); }
int toScreenY(real y) { return int((y - ycamera) * buffer->h + buffer->h * 0.5); }

void rotate_sprite_aa(BITMAP *, BITMAP *, real, real, real, real, real, real);

class world_type;

class object_type { public:
  world_type *system;
  object_type *owner;
  real x, y, spin;
  BITMAP *frame;
  real health;
  int antialias;
  int draw_frame;
  object_type() { frame = 0; x = y = 0.0; system = 0; owner = 0; health = 0.0; spin = 0.0; antialias = default_antialias; draw_frame = 1; }
  virtual void drawFrame() {
    if (frame && draw_frame) {
      if (!spin) {
        draw_sprite(buffer, frame, toScreenX(x) - frame->w / 2, toScreenY(y) - frame->h / 2);
      } else if (antialias) {
        rotate_sprite_aa(buffer, frame, toScreenX(x), toScreenY(y), frame->w * 0.5, frame->h * 0.5, 2 * M_PI * spin, 1);
      } else {
        rotate_sprite(buffer, frame, toScreenX(x) - frame->w / 2, toScreenY(y) - frame->h / 2, int((256 << 16) * spin));
      }
    }
  }
  virtual void update() { }
  virtual void collide(object_type &) { }
  void remove();
  virtual void destroy(object_type &) { }
  virtual void takeDamage(object_type &other, real damage) { health -= damage; if (health <= 0.0) { destroy(other); } }
};

#ifndef max
#define max(a, b) (((a) > (b)) ? (a): (b))
#define min(a, b) (((a) < (b)) ? (a): (b))
#endif
int collide_detect(int xmin1, int ymin1, BITMAP *sprite1, int xmin2, int ymin2, BITMAP *sprite2) {
  int xmax1 = xmin1 + sprite1->w, ymax1 = ymin1 + sprite1->h;
  int xmax2 = xmin2 + sprite2->w, ymax2 = ymin2 + sprite2->h;
  int xmin = max(xmin1, xmin2);
  int ymin = max(ymin1, ymin2);
  int xmax = min(xmax1, xmax2);
  int ymax = min(ymax1, ymax2);
  if (xmax <= xmin || ymax <= ymin) { return 0; }
  int mask1 = bitmap_mask_color(sprite1);
  int mask2 = bitmap_mask_color(sprite2);
  for (int y = ymin; y < ymax; y++) {
    for (int x = xmin; x < xmax; x++) {
      int x1 = x - xmin1, y1 = y - ymin1;
      int x2 = x - xmin2, y2 = y - ymin2;
      int color1 = getpixel(sprite1, x1, y1);
      int color2 = getpixel(sprite2, x2, y2);
      if (color1 != mask1 && color2 != mask2) { return 1; }
    }
  }
  return 0;
}

int do_collide(object_type *a, object_type *b) {
  if (!a || !b) { return 0; }
  if (!a->frame || !b->frame) { return 0; }
  return collide_detect(int(a->x*buffer->h - a->frame->w*0.5), int(a->y*buffer->h - a->frame->h*0.5), a->frame,
                        int(b->x*buffer->h - b->frame->w*0.5), int(b->y*buffer->h - b->frame->h*0.5), b->frame);
/*
  return (a->x*buffer->h - a->frame->w * 0.5 < b->x*buffer->h + b->frame->w * 0.5) &&
         (a->y*buffer->h - a->frame->h * 0.5 < b->y*buffer->h + b->frame->h * 0.5) &&
         (b->x*buffer->h - b->frame->w * 0.5 < a->x*buffer->h + a->frame->w * 0.5) &&
         (b->y*buffer->h - b->frame->h * 0.5 < a->y*buffer->h + a->frame->h * 0.5);
*/
}

class world_type { public:
  object_type **data;
  int count;
  int capacity;
  world_type() { data = 0; count = capacity = 0; }
// memory leak in next two lines
  ~world_type() { if (data) { delete[] data; } }
  void reset() { count = 0; for (int i = 0; i < capacity; i++) { data[i] = 0; } }
  void add(object_type *obj) {
    int i;
    for (i = 0; i < capacity; i++) {
      if (!data[i]) { break; }
    }
    if (i >= capacity) {
      capacity = i * 2 + 1;
      object_type **old_data = data;
      data = new object_type *[capacity];
      memcpy((void *) data, old_data, sizeof(object_type *) * count);
      memset((void *) (data + count), 0, sizeof(object_type *) * (capacity - count));
      delete[] old_data;
    }
    if (i >= count) { count = i + 1; }
    data[i] = obj;
    obj->system = this;
  }
  void update() {
    for (int i = 0; i < count; i++) {
      if (data[i]) { data[i]->drawFrame(); if (data[i]) { data[i]->update(); } }
    }
  }
  void collide(world_type &other) {
    for (int i = 0; i < count; i++) {
      if (data[i]) {
        for (int j = (&other == this ? i + 1: 0); j < other.count; j++) {
          if (other.data[j] && do_collide(data[i], other.data[j])) {
            data[i]->collide(*other.data[j]);
            if (other.data[j] && data[i]) {
              other.data[j]->collide(*data[i]);
            }
          }
          if (!data[i]) { break; }
        }
      }
    }
  }
  void remove_by_owner(object_type *owner) {
    for (int i = 0; i < count; i++) {
      if (data[i] && data[i]->owner == owner) { data[i]->remove(); }
    }
  }
} world, projectile, hostile, message, item;

void object_type::remove() {
  for (int i = 0; i < system->count; i++) {
    if (system->data[i] == this) { system->data[i] = 0; break; }
  }
  delete this;
}

#endif
