#ifndef _dsquare_h
#define _dsquare_h

#include <stdlib.h>
#include <math.h>
#ifndef rnd
#define rnd() (double(rand()) / (double(RAND_MAX) + 1.0))
#define crnd() ((double(rand()) / double(RAND_MAX)) * 2.0 - 1.0)
#endif

#define item(x, y) map[(((y) & ymap_and) << xdepth) + ((x) & xmap_and)]

int diamond_square_size(int depth) {
  return 1 << depth;
}

void normalize_map(int xdepth, int ydepth, float *map, float range_min = 0.0, float range_max = 1.0) {
  int elem_count = 1 << (xdepth + ydepth);
  float min, max;
  min = max = map[0];
  int i;
  for (i = 1; i < elem_count; i++) {
    if (map[i] > max) { max = map[i]; }
    if (map[i] < min) { min = map[i]; }
  }
  float scale = (max != min) ? ((range_max - range_min) / (max - min)) : 1.0;
  float offset = -min * scale + range_min;
  for (i = 0; i < elem_count; i++) {
    map[i] = map[i] * scale + offset;
  }
}

/* map should be a square 2d array of floats, sized
   diamond_square_size(depth) x diamond_square_size(depth) */

void diamond_square(int xdepth, int ydepth, float *map, float decay) {
  int xmap_size = 1 << xdepth;
  int ymap_size = 1 << ydepth;
  int ymap_and = ymap_size - 1;
  int xmap_and = xmap_size - 1;
  int map_size = xmap_size < ymap_size ? xmap_size: ymap_size;

  int x, y;

  int i, elem_count = 1 << (xdepth + ydepth);
  //map[0] = 0.0;       // baseline value
  for (i = 0; i < elem_count; i++) { map[i] = 0; }

  double range = 1.0;
  int depth = xdepth < ydepth ? xdepth: ydepth;
  for (i = 0; i < depth; i++) {

    // subdivide diamonds
    int step = map_size >> i, hstep = step >> 1;
    for (y = hstep; y < ymap_size; y += step) {
      for (x = hstep; x < xmap_size; x += step) {
        item(x, y) = (item(x - hstep, y - hstep) + item(x + hstep, y - hstep) +
                      item(x - hstep, y + hstep) + item(x + hstep, y + hstep)) * 0.25 + crnd() * range;
      }
    }

    range *= decay;

    // subdivide squares
    for (y = 0; y < ymap_size; y += hstep) {
      for (x = 0; x < xmap_size; x += hstep) {
        if ((x / hstep + y / hstep) & 1) {
          item(x, y) = (item(x - hstep, y) + item(x + hstep, y) +
                        item(x, y - hstep) + item(x, y + hstep)) * 0.25 + crnd() * range;
        }
      }
    }

    range *= decay;
  }
}

void adjust_map(int xdepth, int ydepth, float *map, float power) {
  int i, elem_count = 1 << (xdepth + ydepth);
  float min, max;
  min = max = map[0];
  for (i = 1; i < elem_count; i++) {
    if (map[i] > max) { max = map[i]; }
    if (map[i] < min) { min = map[i]; }
  }
  float mid = (min+max) / 2, range = (max-min) / 2;
  for (i = 0; i < elem_count; i++) {
    float val = map[i] - mid;
    if (val > 0) { val = pow(val / range, power) * range; }
    else { val = pow(val / -range, power) * -range; }
    map[i] = val + mid;
  }
}

#undef item

int ilog2(int x) { int i = 0; while (x > 1) { x >>= 1; i++; } return i; }

BITMAP *create_map(int w, int h) {
  int xdepth = ilog2(w), ydepth = ilog2(h);
  if (w != (1 << xdepth) || h != (1 << ydepth)) { return 0; }

  BITMAP *result = create_bitmap(w, h);
  float *map = new float[w * h];
  diamond_square(xdepth, ydepth, map, 0.8);

  const int range = 1024;
  int cmap[range];
  int color_count = 7;
  int color[] = {
                  0, 128, 255,
                  0, 0, 128,
                  40, 95, 0,
                  0, 150, 0,
                  80, 40, 0,
                  150, 100, 0,
                  255, 255, 255
                  };

  adjust_map(xdepth, ydepth, map, .9);
  normalize_map(xdepth, ydepth, map, 0, range - 1);
  for (int i = 0; i < range; i++) {
    int current = i * (color_count-1) / range;
    double t = (i - (current * range / (color_count-1))) / double(range / (color_count-1));
    double u = 1 - t;
    int r = int(color[current*3]   * u + color[current*3+3] * t);
    int g = int(color[current*3+1] * u + color[current*3+4] * t);
    int b = int(color[current*3+2] * u + color[current*3+5] * t);
    if (r < 0) { r = 0; } else if (r > 255) { r = 255; }
    if (g < 0) { g = 0; } else if (g > 255) { g = 255; }
    if (b < 0) { b = 0; } else if (b > 255) { b = 255; }
    cmap[i] = makecol(r/2, g/2, b/2);
  }

  for (int y = 0; y < h; y++) {
    for (int x = 0; x < w; x++) {
      putpixel(result, x, y, cmap[int(map[y*w+x])]);
    }
  }
  delete[] map;
  return result;
}

#endif
