#ifndef _dos32_h
#define _dos32_h

#include <allegro.h>
#define buffer_count 1

#define idle_func()
#define update_frameinfo()

#define __timer_func() (elapsed_time / 1000.0)
volatile long elapsed_time = 0;
void __inc_elapsed_time() { elapsed_time++; }
END_OF_FUNCTION(__inc_elapsed_time);

#include "particle.h"
#include "filter.h"
#include "blur.h"

BITMAP *buffer;
void init_all(int w, int h, int d) {
  allegro_init();

  install_keyboard();
  install_timer();

  LOCK_VARIABLE(elapsed_time);
  LOCK_FUNCTION(__inc_elapsed_time);
  install_int_ex(__inc_elapsed_time, BPS_TO_TIMER(1000));

  set_color_depth(d);
  if (set_gfx_mode(GFX_AUTODETECT, w, h, 0, 0)) {
    die("Couldn't set video mode: %dx%dx%d", w, h, d);
  }

  buffer = create_bitmap(w, h);
  if (!buffer) { die("Couldn't create buffer: %dx%dx%d", w, h, d); }
}

void die(char *format, ...) {
  char buf[1024];
  va_list ap;
  va_start(ap, format);
  vsprintf(buf, format, ap);
  va_end(ap);
  set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
#if(ALLEGRO_DATE>20000000)
  allegro_message(buf);
#else
  printf("%s\n", buf);
#endif
  exit(0);
}


#endif
