#ifndef _win32_font
#define _win32_font

class font_type { public:
  BITMAP *glyph[256];
  int height;
  font_type(char *filename, int base = 32) {
    for (int i = 0; i < 256; i++) { glyph[i] = 0; }
    BITMAP *bmp = load_bitmap(filename, 0);
    if (!bmp) { die("Couldn't load font resource: %s", filename); }
    int scol = getpixel(bmp, 0, 0);
    int x=1, y=1, xstart, ystart, w, h;
    height = 0;
    while (y < bmp->h) {
      for (;;) {
        for (; x < bmp->w; x++) { if (getpixel(bmp, x, y) != scol) { break; } }
        if (x >= bmp->w) { break; }
        xstart = x;
        ystart = y;
        for (; x < bmp->w; x++) { if (getpixel(bmp, x, y) == scol) { break; } }
        if (x >= bmp->w) { break; }
        w = x - xstart;
        x--;
        for (; y < bmp->h; y++) { if (getpixel(bmp, x, y) == scol) { break; } }
        h = y - ystart;
        if (h > height) { height = h; }
        y = ystart;
        x++;
        glyph[base] = create_bitmap(w, h);
        blit(bmp, glyph[base], xstart, ystart, 0, 0, w, h);
        base++;
      }
      x = 1;
      y += h;
      for (; y < bmp->h; y++) { if (getpixel(bmp, x, y) != scol) { break; } }
    }
    destroy_bitmap(bmp);
  }
  ~font_type() { for (int i = 0; i < 256; i++) { if (glyph[i]) { destroy_bitmap(glyph[i]); } } }
};

void textout(screen_type *bmp, font_type *f, char *s, int xbase, int ybase, int r, int g, int b, int a) {
  int x = xbase, y = ybase;
  for (; *s != '\0'; s++) {
    char ch = *s;
    if (ch == '\n') { x = xbase; y += f->height; }
    else {
      BITMAP *glyph = f->glyph[(unsigned char) ch];
      blit_additive(glyph, bmp, 0, 0, x, y, glyph->w, glyph->h, r, g, b, a);
      x += glyph->w;
    }
  }
}

void textprintf(screen_type *bmp, font_type *f, int xbase, int ybase, int r, int g, int b, int a, char *format, ...) {
  char buf[1024];
  va_list ap;
  va_start(ap, format);
  vsprintf(buf, format, ap);
  va_end(ap);
  textout(bmp, f, buf, xbase, ybase, r, g, b, a);
}

int text_length(font_type *f, char *s) {
  int result = 0;
  for (; *s != '\0' && *s != '\n'; s++) {
    result += f->glyph[(unsigned char) *s]->w;
  }
  return result;
}
int text_height(font_type *f) { return f->height; }

void textout_centre(screen_type *bmp, font_type *f, char *s, int xbase, int ybase, int r, int g, int b, int a) {
  int x = xbase - text_length(f, s) / 2, y = ybase;
  for (; *s != '\0'; s++) {
    char ch = *s;
    if (ch == '\n') { x = xbase - text_length(f, s + 1) / 2; y += f->height; }
    else {
      BITMAP *glyph = f->glyph[(unsigned char) ch];
      blit_additive(glyph, bmp, 0, 0, x, y, glyph->w, glyph->h, r, g, b, a);
      x += glyph->w;
    }
  }
}

void textprintf_centre(screen_type *bmp, font_type *f, int xbase, int ybase, int r, int g, int b, int a, char *format, ...) {
  char buf[1024];
  va_list ap;
  va_start(ap, format);
  vsprintf(buf, format, ap);
  va_end(ap);
  textout_centre(bmp, f, buf, xbase, ybase, r, g, b, a);
}

#endif
