
// fixme: make overlay[8] be 8 background bitmaps so GL won't complain
// space.cpp: fly a spaceship around

#ifdef GL
#include "win32.h"
#else
#include "dos32.h"
#endif

#include "global.h"
#include <stdio.h>
#include <math.h>
#include <time.h>
#include "object.h"
#include "dsquare.h"

#ifndef WIN32
#ifdef BEGIN_DIGI_DRIVER_LIST
BEGIN_DIGI_DRIVER_LIST   DIGI_DRIVER_SB  END_DIGI_DRIVER_LIST
BEGIN_COLOR_DEPTH_LIST   COLOR_DEPTH_8   COLOR_DEPTH_16   COLOR_DEPTH_32  END_COLOR_DEPTH_LIST
BEGIN_MIDI_DRIVER_LIST   MIDI_DRIVER_MPU END_MIDI_DRIVER_LIST
BEGIN_GFX_DRIVER_LIST    GFX_DRIVER_VBEAF  GFX_DRIVER_VESA3 GFX_DRIVER_VESA2L GFX_DRIVER_VESA2B GFX_DRIVER_VESA1 END_GFX_DRIVER_LIST
#endif
#endif

const int move_normal = 0, move_down = 1, move_up = 2, move_split = 3, move_either = 4, move_train_down = 5, move_train_up = 6, move_sine_down = 7, move_sine_up = 8, move_zigzag_down = 9, move_zigzag_up = 10, move_squarewave = 11, move_dart_down = 12, move_dart_up = 13, move_squarewave2 = 14;
const int obj_checkpoint = 100, obj_weapon = 104, obj_health = 102, obj_message = 103, obj_shield = 105, obj_nuke = 106, obj_boss = 201;

class msgtext { public:
  union { real value; char *ptr; };
  msgtext(real x) { ptr = 0; value = x; }
  msgtext(char *s) { value = 0; ptr = s; }
};

int scr_width = 640, scr_height = 480;

BITMAP *image_star[10], *image_particle, *image_particle2, *image_particle3, *image_particle4, *image_particle5, *image_particle6, *image_particle7, *image_particle8, *image_ship, *image_dot;
BITMAP *image_particle5_flip, *image_pause;
BITMAP *image_enemy[50], *image_item[10], *image_boss[10], *image_menu[10];

BITMAP *image_blank_laser, *image_blank_laser2;
font_type *message_font;

SAMPLE *sample_laser, *sample_laser2, *sample_shot, *sample_shot2, *sample_item, *sample_explode, *sample_explode2, *sample_explode3;
SAMPLE *sample_activate, *sample_wind, *sample_wind2;

const real pscale = 0.75;
real scroll_speed = 3.0;
real cscroll = 0.0, wscroll = 0.0;
int cscore = 0;
real leveldone_time = 0.0;
int wave_position = 0;
int current_level;
real *wave = 0;
int menu_active = 1, menu_toggle = 1, do_exit = 0;
real max_fps = 0, fps = 0;

char *global_message[256];
int message_count = 0;
#ifndef WIN32
int reverse_stereo = 1;
#else
int reverse_stereo = 0;
#endif

real virtualw = 1.33333;
real virtualh = 2.0;
real clip_right = virtualw + .3, clip_left = -.3, clip_top = -.1, clip_bottom = virtualh + .1;
int stars_enabled = 1;

int get_panning(object_type *obj) {
  int pan = int(255.0 * obj->x / virtualw);
  if (pan < 0) { pan = 0; }
  if (pan > 255) { pan = 255; }
  return reverse_stereo ? (255 - pan): (pan);
}

void init_all();
int depth_select(int);
int fire_button() { return key[KEY_LCONTROL] || key[KEY_RCONTROL]; }

void add_star(real x, real y) {
  if (!stars_enabled) { return; }
  real radius = .015 + .030 * rnd();
  real life = 25.0 - radius / .045 * 20.0;
  real xvel = -(1.0 + 2 * radius) / life * scroll_speed;
  real opacity = radius * radius / .030 / .030 * 192.0;
  int num = 1;
  int r = rand() % 30;
  if (r == 1) { num = 3; }
  if (r == 2) { num = 4; }
  real red   = 255;
  real green = 255 - rnd() * 64;
  real blue  = 255;
  real live_time = (x+.1) / -xvel;
  add_particle(x, y, xvel, 0, 0, 0,
               red, green, blue, opacity, radius/2,
               red, green, blue, opacity, radius/2,
               live_time, image_star[num]);
}

class ion_fire: public object_type { public:
  real xvel, yvel, x1;
  real red1, red2, green1, green2, blue1, blue2;
  real radius, alpha, fade, time0, damage, glow_time, trail_time;
  int type;
  BITMAP *p;
  ion_fire(object_type *o, real xv, real yv, int t) {
    frame = image_dot; draw_frame = 0; damage = 1; glow_time = 0;
    x1 = o->x; if (x1 >= virtualw) { x1 = virtualw - .1; }
    owner = o; x = owner->x; y = owner->y; xvel = xv; yvel = yv; time0 = frame_time;
    red1 = red2 = green1 = green2 = blue1 = blue2 = 0.0;
    alpha = 255.0; radius = .025; fade = 0.0; trail_time = 0;
    switch (type = t) {
      case 1: red1 = red2 = green1 = 255; p = image_particle2; radius *= 4; break;
      case 2: green1 = green2 = blue1 = 255; p = image_particle6; radius *= 4 * real(image_particle6->w) / image_particle2->w; damage = 1.5; break;

      case 3: red1 = blue1 = red2 = 255; p = image_particle2; radius *= 4; damage = 1.5; break;
      case 4: red1 = blue1 = red2 = 255; p = image_particle5; radius *= 4; damage = .5; break;
      case 5: red1 = blue1 = red2 = 255; p = image_particle5_flip; radius *= 4; damage = .5; break;

      case 6: green1 = green2 = blue1 = 255; p = image_particle6; radius *= 4 * real(image_particle6->w) / image_particle2->w; damage = 1.5; break;
      case 7: blue1 = blue2 = green1 = 255; p = image_particle5; radius *= 4; damage = .5; break;
      case 8: blue1 = blue2 = green1 = 255; p = image_particle5_flip; radius *= 4; damage = .5; break;

      case 9: blue1 = blue2 = red1 = 255; p = image_particle2; radius *= 4; damage = 1; break;

  /* used colors:
     red    -> purple
     red    -> yellow
     green  -> yellow
     green  -> cyan
     cyan   -> green
     cyan   -> blue
     blue   -> cyan
     blue   -> purple
     purple -> blue

     possible colors: red, yellow, green, cyan, blue, purple
  */
      case 101: green2 = 255; blue1 = green1 = 255; fade = 0; p = image_particle; break;
      case 102: green2 = 255; red1 = red2 = 255; fade = 0; p = image_particle; break;
      case 103: red1 = red2 = 255; blue2 = 255; fade = 0; p = image_particle; break;
      case 104: red1 = red2 = green2 = 255; p = image_particle; fade = .1; break;
      case 105: green1 = blue1 = blue2 = 255; green2 = 0; radius *= 3; p = image_particle2; break;
      case 106: blue1 = blue2 = green2 = 255; fade = 0; p = image_particle; break;
      case 107: green1 = green2 = red2 = 255; fade = 0; p = image_particle; break;
      case 108: red1 = red2 = green1 = 255; fade = .05; p = image_particle; break;
      case 109: green1 = green2 = blue2 = 255; fade = 0; p = image_particle; break;
      case 110: red1 = blue2 = red2 = 255; fade = 0; p = image_particle; break;
    }
  }
  void update() {
    x += xvel * dt; y += yvel * dt;
    if (x < clip_left || y < clip_top || x > clip_right || y > clip_bottom) { remove(); return; }
    real t = (x - x1) / (virtualw - x1);
    if (type >= 100) { t = (frame_time - time0) / 1.0; clip(t, 0, 1); }
    real red   = t * (red2 - red1) + red1;
    real green = t * (green2 - green1) + green1;
    real blue  = t * (blue2 - blue1) + blue1;
    if (!fade || frame_time > trail_time + .015) {
      add_particle(x, y, 0, 0, 0, 0,
                   red, green, blue, 255, (p != image_particle) ? radius: (radius * pscale),
                   red, green, blue, 0, (p != image_particle) ? radius: (radius * pscale),
                   fade, p);
      trail_time = frame_time;
    }
  }
  void collide(object_type &other) {
    if (owner && other.system != owner->system) {
      other.takeDamage(*owner, damage);
      remove();
    }
  }
//  void collide(object_type &other) { if (owner && &other != owner) { other.takeDamage(*owner, 1); remove(); } }
};

class random_interpolator { public:
  real last_time;
  real val1, val2, period;
  void new_set() { last_time = frame_time; val1 = val2; val2 = crnd(); }
  random_interpolator() { last_time = 0; val2 = 0.0; }
  real evaluate() {
    if (frame_time - last_time > period) { new_set(); }
    real t = (frame_time - last_time) / period;
    if (t < .5) { t*=2*t; }
    if (t > .5) { t=1-t; t*=2*t; t=1-t; }
    return val1 + (val2 - val1) * t;
  }
};

class nuke_type: public object_type { public:
  real time0, length;
  int used;
  nuke_type(real timelen) { time0 = frame_time; length = timelen; used = 0; }
  void update() {
    real t = (frame_time - time0) / length;
    if (t > 1) { remove(); return; }
    real rampup_time = .1;
    if (t < rampup_time) {
      int lum = int(255*t/rampup_time);
      tint_additive(buffer,lum,lum/2,0);
    } else {
      int lum = int(255*(1-t)/(1-rampup_time));
      tint_additive(buffer,lum,lum/2,0);
      if (!used) {
        for (int i = 0; i < hostile.count; i++) {
          if (hostile.data[i] && hostile.data[i]->health < 20) { hostile.data[i]->destroy(*this); }
        }
        projectile.reset();
        used = 1;
      }
    }
  }
};

class player_type: public object_type { public:
  real xvel, yvel, xcentral, ycentral, ydisplace, fire_time;
  real change_time, engine_time;
  int score, alive, maxhealth, weapon, weapon_count, fire_count;
  real shield_health;
  void reset() { health = maxhealth; xcentral = .05; ycentral = 1.0; ydisplace = 0; score = 0; alive = 1; score = cscore; change_time = 0; fire_count = 0; }
  void die_reset() { weapon = 1; shield_health = 0; }
  void regen(real amt) { health += amt; if (health > maxhealth) { health = maxhealth; } }
  player_type() { maxhealth = 20; weapon_count = 5; reset(); fire_time = 0.0; engine_time = 0; weapon = 1; shield_health = 0; }
  int can_upgrade() {
    return weapon < current_level + 1;
  }
  void weapon_upgrade() {
    if (!can_upgrade()) { return; }
    weapon++;
    if (weapon > weapon_count) { weapon = weapon_count; }
  }
  void shield_upgrade() {
    shield_health = 15;
  }
  void missile_upgrade() {
    world.add(new nuke_type(1.0));
  }
  void move_to(real xval, real yval) {
    x = xval; y = yval;
    xcentral = x;
    ycentral = y - ydisplace;
    clip(xcentral, .05, virtualw - .05);
    clip(ycentral, .1, virtualh - .1);
  }
  void update() {
    if (!alive) { frame = 0; return; }
    frame = image_ship;
    real displacevel = .2;
    xvel = yvel = 0.0;
    if (key[KEY_DOWN]) { yvel += .7; }
    if (key[KEY_UP])   { yvel -= .7; }
    if (key[KEY_LEFT])  { xvel -= .7; }
    if (key[KEY_RIGHT]) { xvel += .7; }
    real ydelta, xdelta, vel, angle;
    if (shield_health) {
      real rad = image_particle8->w*virtualw/buffer->w/2;
      real alpha = 255.0;
      if (shield_health <= 4) {
        real minalpha = 64;
        real maxalpha = minalpha + 128.0*shield_health/4;
        alpha = (sin(frame_time*8*M_PI)*.5+.5)*(maxalpha-minalpha)+minalpha;
      }
      add_particle(x, y, 0, 0, 0, 0,
                   255, 255, 255, alpha, rad,
                   255, 255, 255, alpha, rad,
                   0, image_particle8);
    }
    if (fire_button() && frame_time > fire_time) {
      play_sample(sample_laser2, 255, get_panning(this), int(1000+crnd()*100), 0);
      switch (weapon) {
        case 1: projectile.add(new ion_fire(this, 3.0, 0, 1));
                fire_time = frame_time + .08;
                break;
        case 2: ydelta = .015;
                xdelta = .03;
                x += xdelta;
                y += ydelta;
                projectile.add(new ion_fire(this, 3.0, 0, 9));
                y -= ydelta * 2;
                projectile.add(new ion_fire(this, 3.0, 0, 9));
                y += ydelta;
                x -= xdelta;
                fire_time = frame_time + .10;
                break;
        case 3: ydelta = .015;
                xdelta = .03;
                x += xdelta;
                y += ydelta;
                projectile.add(new ion_fire(this, 3.0, 0, 2));
                y -= ydelta * 2;
                projectile.add(new ion_fire(this, 3.0, 0, 2));
                y += ydelta;
                x -= xdelta;
                fire_time = frame_time + .12;
                break;
        case 4: vel = 3;
                angle = 0;
                projectile.add(new ion_fire(this, cos(angle)*vel, sin(angle)*vel, 3));
                angle = -20 / 180.0 * M_PI;
                projectile.add(new ion_fire(this, cos(angle)*vel, sin(angle)*vel, 4));
                angle = 20 / 180.0 * M_PI;
                projectile.add(new ion_fire(this, cos(angle)*vel, sin(angle)*vel, 5));
                fire_time = frame_time + .08;
                break;
        case 5: ydelta = .015;
                xdelta = .03;
                vel = 3;
                angle = 0;
                if (fire_count & 1) {
                  x += xdelta;
                  y += ydelta;
                  projectile.add(new ion_fire(this, 3.0, 0, 6));
                  y -= ydelta * 2;
                  projectile.add(new ion_fire(this, 3.0, 0, 6));
                  y += ydelta;
                  x -= xdelta;
                }
                angle = -20 / 180.0 * M_PI;
                projectile.add(new ion_fire(this, cos(angle)*vel, sin(angle)*vel, 7));
                angle = 20 / 180.0 * M_PI;
                projectile.add(new ion_fire(this, cos(angle)*vel, sin(angle)*vel, 8));
                fire_time = frame_time + .08;
                break;
      }
      fire_count++;
    }
//    if (key[KEY_PLUS_PAD] && frame_time > change_time + .5) { weapon++; change_time = frame_time; if (weapon > weapon_count) { weapon = weapon_count; } }
//    if (key[KEY_MINUS_PAD] && frame_time > change_time + .5) { weapon--; change_time = frame_time; if (weapon < 1) { weapon = 1; } }
    if (!yvel) { decay(ydisplace, displacevel * dt); }
    else if (yvel > 0) { ydisplace += displacevel * dt; }
    else if (yvel < 0) { ydisplace -= displacevel * dt; }
    clip(ydisplace, -.05, .05);
    xcentral += xvel * dt;
    ycentral += yvel * dt;
    clip(xcentral, .05, virtualw - .05);
    clip(ycentral, .1, virtualh - .1);
    x = xcentral;
    y = ycentral + ydisplace;

    real life = 0.5 + .25 * rnd();
    real pxvel = (-.1 + .05 * rnd()) / life;
    real pyvel = (.05 * crnd()) / life;

    if (frame_time > engine_time) {
      add_particle(x, y, pxvel, pyvel, 0, 0,
                   64, 255, 255, 192, .008*pscale,
                   0, 0, 255, 0, .03*pscale,
                   life, image_particle);
      engine_time = frame_time + 1/80.0;
    }
  }
  void takeDamage(object_type &other, real damage) {
    if (shield_health) {
      shield_health -= damage;
      if (shield_health < 0) { shield_health = 0; }
    } else { health -= damage; }
    if (health <= 0.0) { destroy(other); }
  }

  void destroy(object_type &attacker) {
    play_sample(sample_explode, 255, get_panning(this), 1000, 0);
    die_reset();
    if (health < 0) { health = 0; }
    int count;
    count = 64;
    for (real life = 1.0; life <= 2.0; life += 0.5) {
      for (int i = 0; i < count; i++) {
//        real life = 3.0;
        real angle = i*2*M_PI / count;
        real dist = 0.5;
        add_particle(x+dist*cos(angle), y+dist*sin(angle), -dist*cos(angle)/life, -dist*sin(angle)/life, 0, 0,
                     255, 255, 0, 0, .03*pscale,
                     255, 64, 64, 192, .03*pscale,
                     life, image_particle);
      }
    }
    count = (rand() % 25) + 75;
    for (int i = 0; i < count; i++) {
      real xdiff=crnd(),ydiff=crnd();
      real radius=.30*rnd(); //sqrt(rnd())*0.30;
      real r1 = 0.15 * rnd();
      normalize(xdiff,ydiff);
      real xm=xdiff*r1,ym=ydiff*r1;
      xdiff*=radius; ydiff*=radius;
      real life = 1+rnd()*2;
      real pxvel = (xdiff - xm) / life, pyvel = (ydiff - ym) / life;
      add_particle(x + xm, y + ym, pxvel, pyvel, 0, 0,
                   255, 255, 64, 255, .10*rnd()*pscale,
                   255, 0, 0, 0, .05*rnd()*pscale,
                   life, image_particle);
    }
    alive = 0;
  }
};
player_type *player;

class comet_type: public object_type { public:
  real spark_time;
  comet_type() { x = virtualw + 1; y = rnd() * virtualh; spark_time = 0; }
  void update() {
    x -= .15 * scroll_speed * dt;
    if (x < clip_left) { remove(); return; }
    if (frame_time - spark_time > .05) {
      real life = 5.0 + rnd();
      real xvel = -(.15 * scroll_speed - .04); //-.12;
      real yvel = (.08 * crnd()) / life;
      add_particle(x, y, xvel, yvel, 0, 0,
                   192, 192, 255, 255, .008*pscale,
                   128, 128, 255, 64, 0*pscale,
                   life, image_particle);
      spark_time = frame_time;
    }
  }
};

real reduce(real x) { return x; if (x > 0) { return log(x); } return 0; }

class item_type: public object_type { public:
  int type;
  real mtype;
  real xvel, yvel;
  item_type(int n, real xval, real yval, real m) {
    y = yval; x = xval; xvel = -.6; yvel = 0; mtype = m;
    switch (type = n) {
      case obj_checkpoint:
        if (player->alive) {
          cscore = player->score;
          cscroll = wscroll;
        }
        break;
      case obj_health:
        frame = image_item[1];
        xvel = -.3;
        yvel = crnd() * .2;
        play_sample(sample_item, 200, get_panning(this), int(1000+crnd()*100), 0);
        break;
      case obj_weapon:
        frame = image_item[2];
        xvel = -.3;
        yvel = crnd() * .2;
        if (player->can_upgrade()) { play_sample(sample_item, 200, get_panning(this), int(1000+crnd()*100), 0); }
        break;
      case obj_shield:
        frame = image_item[3];
        xvel = -.3;
        yvel = crnd() * .2;
        play_sample(sample_item, 200, get_panning(this), int(1000+crnd()*100), 0);
        break;
      case obj_nuke:
        frame = image_item[4];
        xvel = -.3;
        yvel = crnd() * .2;
        play_sample(sample_item, 200, get_panning(this), int(1000+crnd()*100), 0);
        break;
    }
  }
  void update() {
    if (type == obj_weapon && !player->can_upgrade()) { remove(); return; }
    x += xvel * dt; y += yvel * dt;
    char *text;
    int alpha;
    if (x < clip_left || y < clip_top || x > clip_right || y > clip_bottom) { remove(); return; }
    real yval;
    switch (type) {
      case obj_checkpoint: case obj_message:
        if (type == obj_checkpoint) { text = "- checkpoint -"; }
        else if (type == obj_message) { text = global_message[int(mtype)]; }
        alpha = int(192 * sin(M_PI * (virtualw - x) / virtualw));
        clip(alpha, 0, 255);
        for (yval = 0.20; yval <= 1.80; yval += .40) {
          textout_centre(buffer, message_font, text, toScreenX(x), toScreenY(yval), 255, 255, 255, alpha);
        }
        break;
      case obj_health:
        add_particle(x, y, xvel, yvel, 0, 0,
                     255, 0, 255, 128, .15*pscale,
                     255, 0, 255, 128, .15*pscale,
                     0, image_particle);
        break;
      case obj_weapon:
        add_particle(x, y, xvel, yvel, 0, 0,
                     0, 255, 0, 128, .15*pscale,
                     0, 255, 0, 128, .15*pscale,
                     0, image_particle);
        break;
      case obj_shield:
        add_particle(x, y, xvel, yvel, 0, 0,
                     0, 0, 255, 128, .15*pscale,
                     0, 0, 255, 128, .15*pscale,
                     0, image_particle);
        break;
      case obj_nuke:
        add_particle(x, y, xvel, yvel, 0, 0,
                     255, 127, 0, 128, .15*pscale,
                     255, 127, 0, 128, .15*pscale,
                     0, image_particle);
        break;
    }
  }
  void collide(object_type &other) {
    if (type == obj_weapon && !player->can_upgrade()) { remove(); return; }
    if (&other == player && player->alive) {
      switch (type) {
        case obj_health: player->regen(player->maxhealth); remove(); break;
        case obj_weapon: player->weapon_upgrade(); remove(); break;
        case obj_shield: player->shield_upgrade(); remove(); break;
        case obj_nuke: player->missile_upgrade(); remove(); break;
      }
    }
  }

};

class message_type: public object_type { public:
  char msg[256];
  real time0, xvel, yvel;
  message_type(real xval, real yval, real xv, real yv, char *format, ...) {
    va_list ap;
    va_start(ap, format);
    vsprintf(msg, format, ap);
    va_end(ap);
    x = xval; y = yval; xvel = xv; yvel = yv; time0 = frame_time;
  }
  void update() {
    x += xvel * dt;
    y += yvel * dt;
    int alpha = int(255.0 - (frame_time - time0) / 1.5 * 255.0);
    if (alpha < 0) { remove(); return; }
    textout_centre(buffer, message_font, msg, toScreenX(x), toScreenY(y) - text_height(message_font) / 2, 255, 255, 255, alpha);
  }
};

class boss_laser: public object_type { public:
  real damage, time0, yoffset, xoffset, live_time; BITMAP *laser_bmp;
  boss_laser(object_type *own, real dmg, real xdiff, real ydiff, real tm, BITMAP *bmp) {
    owner = own; damage = dmg; time0 = frame_time; yoffset = ydiff; xoffset = xdiff; live_time = tm; laser_bmp = bmp;
    draw_frame = 0; y = owner->y + yoffset; x = owner->x - virtualw * 0.5 + 0.5 * image_boss[2]->w * virtualw / scr_width;
    if (bmp == image_particle7) { frame = image_blank_laser2; }
    else { frame = image_blank_laser; }
  }
  void update() {
    x = owner->x + xoffset;
    y = owner->y + yoffset;
    real alpha = 255;
    if (frame_time > time0 + live_time) {
      alpha = 255 - 255 * (frame_time - time0 - live_time) / .2;
      if (alpha < 0) { remove(); return; }
    }
    add_particle(x, y, 0, 0, 0, 0,
                 255, 255, 255, alpha, 0.5 * virtualw,
                 255, 255, 255, alpha, 0.5 * virtualw,
                 0.0, laser_bmp);
  }
  void collide(object_type &other) {
    if (&other != owner) {
      other.takeDamage(*this, damage * dt);
    }
  }
};

void burst_fire(object_type *own, real x, real y) {
  play_sample(sample_shot, 200, get_panning(own), int(400+50*rnd()), 0);
  int count = 5;
  real oldx = own->x, oldy = own->y;
  real range = (y > own->y) ? -M_PI / 2: M_PI / 2;
  real base_angle = M_PI;
  real velocity = .75;
  own->x = x; own->y = y;
  for (int i = 0; i < count; i++) {
    real theta = base_angle + i * range / count;
    projectile.add(new ion_fire(own, cos(theta) * velocity, sin(theta) * velocity, 102));
  }
  own->x = oldx; own->y = oldy;
}

void add_score(int points, real x, real y, real xvel) {
  player->score += points;
  message.add(new message_type(x, y, xvel + rnd() * .05, rnd() * .05, "%d", points));
}

void barrel_explode(real x, real y) {
  add_score(200, x, y, 0);
  item.add(new item_type(obj_health, x, y, 0));
  item.add(new item_type(obj_health, x - .1, y, 0));
  item.add(new item_type(obj_health, x - .2, y, 0));
  int count = (rand() % 10) + 25;
  for (int i = 0; i < count; i++) {
    real xdiff=crnd(),ydiff=crnd();
    real radius=.20*rnd(); //sqrt(rnd())*0.30;
    real r1 = 0.15 * rnd();
    normalize(xdiff,ydiff);
    real xm=xdiff*r1,ym=ydiff*r1;
    xdiff*=radius*3; ydiff*=radius;
    real life = 1+rnd()*2;
    real pxvel = (xdiff - xm) / life, pyvel = (ydiff - ym) / life;
    add_particle(x + xm, y + ym, pxvel, pyvel, 0, 0,
                 255, 255, 64, 255, .20*rnd()*pscale,
                 255, 0, 0, 255, 0,
                 life, image_particle);
  }
}

void boss_health_meter(real value) {
  value = ceil(value/.05)*.05;
  real w = .3;
  int x1 = int(buffer->w/2 - (w/2)*buffer->w);
  int x2 = int(buffer->w/2 + (w/2)*buffer->w);
  int y1 = 2, y2 = text_height(message_font) - 2;
  rect(buffer, x1, y1, x2, y2, makecol(255, 255, 255));
//  rectfill(buffer, x1+2, y1+2, int(x1+1+(x2-x1-4)*value), y2-2, makecol(255, 255, 128));
  int x3 = int(x1+2+(x2-x1-4)*value);
  int r1=128, g1=128, b1=128, r2=255, g2=255, b2=255;
  rectfill_gouraud(buffer, x1+2, y1+2, x3, (y1+y2)/2, r1,g1,b1, r1,g1,b1, r2,g2,b2, r2,g2,b2);
  rectfill_gouraud(buffer, x1+2, (y1+y2)/2, x3, y2-2, r2,g2,b2, r2,g2,b2, r1,g1,b1, r1,g1,b1);
}

class boss1_type: public object_type { public:
  random_interpolator rvel;
  real time0, xvel, yvel, fire1_time, warn_time, dewarn_time, finished_time;
  real fire2_time, fire3_time, fire3_end, maxhealth;
  int rsign, points, activate_sound;
  int entrance, barrel1, barrel2;
  boss1_type() { rvel.period = .5; x = virtualw + .5; y = 1.00; frame = image_boss[1]; time0 = frame_time; yvel = 0; xvel = -.3; entrance = 1; rsign = 1; fire1_time = frame_time + 2.5; warn_time = .8; dewarn_time = .2; finished_time = 0; fire2_time = frame_time; fire3_end = 0; fire3_time = 0; barrel1 = 1; barrel2 = 1; maxhealth = health = 400; activate_sound = 0; }
  void update() {
// + .04 for align
    boss_health_meter(health / maxhealth);
    if (entrance) { health = maxhealth; }
    if (health < maxhealth * .8 && barrel1) {
      play_sample(sample_explode3, 255, get_panning(this), 1000, 0);
      barrel_explode(x, y - .18);
      barrel1 = 0;
    } else if (health < maxhealth * .4 && barrel2) {
      play_sample(sample_explode3, 255, get_panning(this), 1000, 0);
      barrel_explode(x, y + .18);
      barrel2 = 0;
    }
    if (frame_time > fire2_time) {
      if (barrel1) { burst_fire(this, x - 0.5 * image_boss[2]->w * virtualw / scr_width, y - .18); }
      if (barrel2) { burst_fire(this, x - 0.5 * image_boss[2]->w * virtualw / scr_width, y + .18); }
      fire2_time = frame_time + 2;
    }
    if (!barrel1 || !barrel2) {
      if (frame_time > fire3_time && frame_time < fire3_end) {
        play_sample(sample_shot2, 200, get_panning(this), int(300+50*rnd()), 0);
        for (int i = 0; i < 1; i++) {
          if (!barrel1) {
            real angle = M_PI * (1 + rnd() * .5);
            projectile.add(new ion_fire(this, cos(angle) * .75, sin(angle) * .75, 103));
          }
          if (!barrel2) {
            real angle = M_PI * (1 - rnd() * .5);
            projectile.add(new ion_fire(this, cos(angle) * .75, sin(angle) * .75, 103));
          }
        }
        fire3_time = frame_time + .05;
      } else if (frame_time > fire3_end) {
        fire3_time = fire3_end + 1 + rnd();
        fire3_end = fire3_time + 1.5;
      }
    }
    if (barrel1) { draw_sprite(buffer, image_boss[2], toScreenX(x) - image_boss[2]->w / 2, toScreenY(y - .18) - image_boss[2]->h / 2); }
    if (barrel2) { draw_sprite(buffer, image_boss[2], toScreenX(x) - image_boss[2]->w / 2, toScreenY(y + .18) - image_boss[2]->h / 2); }
    yvel = rvel.evaluate() * .7 * rsign;
    if (x < .8 * virtualw) { entrance = 0; x = .8 * virtualw; xvel = 0; }
    if (!entrance) { y += yvel * dt; }
    x += xvel * dt;
    if (y < .2) { y = .2; rsign = -rsign; }
    if (y > virtualh - .2) { y = virtualh - .2; rsign = -rsign; }
    if (frame_time > fire1_time - warn_time - 1) {
      if (!activate_sound && (barrel1 || barrel2)) {
        play_sample(sample_activate, 255, get_panning(this), 1000, 0);
        activate_sound = 1;
      }
    }
    if (frame_time > fire1_time - warn_time) {
      finished_time = fire1_time + 1 + dewarn_time;
    }
    if (frame_time > fire1_time) {
      real xoffset = -virtualw * 0.5 + 0.5 * image_boss[2]->w * virtualw / scr_width;
      if (barrel1 || barrel2) { play_sample(sample_wind, 255, get_panning(this), 1000, 1); }
      if (barrel1) { projectile.add(new boss_laser(this, 25.0, xoffset, -.18, 1, image_particle3)); }
      if (barrel2) { projectile.add(new boss_laser(this, 25.0, xoffset, .18, 1, image_particle3)); }
      fire1_time = frame_time + 6 + rnd();
      activate_sound = 0;
    }
    if (frame_time < finished_time) {
      real alpha = 255 * (frame_time - (finished_time - 1 - dewarn_time - warn_time)) / warn_time;
      clip(alpha, 0, 255);
      if (frame_time > finished_time - dewarn_time) {
        alpha = 255 - 255 * (frame_time - (finished_time - dewarn_time)) / dewarn_time;
        clip(alpha, 0, 255);
      }
      if (barrel1) {
        add_particle(x - 0.5 * image_boss[2]->w * virtualw / scr_width, y - .18, 0, 0, 0, 0,
                   0, 128, 255, alpha, .3*pscale,
                   0, 128, 255, alpha, .3*pscale,
                   0.0, image_particle);
      }
      if (barrel2) {
        add_particle(x - 0.5 * image_boss[2]->w * virtualw / scr_width, y + .18, 0, 0, 0, 0,
                   0, 128, 255, alpha, .3*pscale,
                   0, 128, 255, alpha, .3*pscale,
                   0.0, image_particle);
      }
    } else { stop_sample(sample_wind); activate_sound = 0; }
  }
  void collide(object_type &other) {
    if (&other == player) {
      player->takeDamage(*this, 9999);
    }
  }
  void destroy(object_type &attacker) {
    play_sample(sample_explode, 255, get_panning(this), 800, 0);
    add_score(1000, x, y, 0);
    int count = 32;
    for (real life = 1.0; life <= 3.0; life += 1.00) {
      for (int i = 0; i < count; i++) {
//        real life = 3.0;
        real angle = i*2*M_PI / count;
        real dist = 0.8;
        add_particle(x+dist*cos(angle), y+dist*sin(angle), -dist*cos(angle)/life, -dist*sin(angle)/life, 0, 0,
                     0, 192, 255, 0, .05*pscale,
                     0, 64, 255, 192, .05*pscale,
                     life, image_particle);
      }
    }
    count = (rand() % 15) + 50;
    for (int i = 0; i < count; i++) {
      real xdiff=crnd(),ydiff=crnd();
      real radius=.50*rnd(); //sqrt(rnd())*0.30;
      real r1 = 0.30 * rnd();
      normalize(xdiff,ydiff);
      real xm=xdiff*r1,ym=ydiff*r1;
      xdiff*=radius; ydiff*=radius;
      real life = 3+rnd()*2;
      real pxvel = (xdiff - xm) / life, pyvel = (ydiff - ym) / life;
      add_particle(x + xm, y + ym, pxvel, pyvel, 0, 0,
                   128, 192, 255, 255, .20*rnd()*pscale,
                   0, 64, 255, 0, -.10*rnd()*pscale,
                   life, image_particle);
    }
    leveldone_time = frame_time + 4.5;
    remove();
  }
};

void boss2_barrel_explode(real x, real y) {
  real xvel=0, yvel=0;
  add_score(500, x, y, xvel);
  int i;
  for (i = 0; i < 4; i++) {
    item.add(new item_type(obj_health, x, y, 0));
  }
  int count = (rand() % 25) + 50;
  for (i = 0; i < count; i++) {
    real xdiff=crnd(),ydiff=crnd();
    real radius=rnd()*0.16;
    real r1 = 0.02;
    normalize(xdiff,ydiff);
    real xm=xdiff*r1,ym=ydiff*r1;
    xdiff*=radius; ydiff*=radius;
    real life = 1+rnd()*4;
    real pxvel = (xdiff - xm) / life, pyvel = (ydiff - ym) / life;
    add_particle(x + xm, y + ym, pxvel + xvel, pyvel, 0, 0,
                 255, 255, 64, 255, .05*rnd()*pscale,
                 255, 0, 0, 0, -.01*rnd()*pscale,
                 life, image_particle);
  }
}

class boss2_type: public object_type { public:
  random_interpolator rvel;
  real xvel, yvel;
  real maxhealth, turret_angle;
  int rsign, points;
  int entrance, turrets;
  real turret_time, fire1_time, turret_radius, fire2_time;
  real wind_time;
  int turret_stop, barrel1, barrel2, shot_count;
  boss2_type() { rvel.period = .35; x = virtualw + .5; y = 1.00; frame = image_boss[3]; yvel = 0; xvel = -.3; entrance = 1; rsign = 1; maxhealth = health = 400; turret_angle = 0; turret_time = 0; turret_stop = 0; fire1_time = 0; turret_radius = .3; barrel1 = 1; barrel2 = 1; fire2_time = 0; turrets = 2; shot_count = 1; wind_time = 0; }
  void update() {
// + .04 for align
// summon bees, seekers
// rotating lasers
// have guns blow up after suitable health loss
    boss_health_meter(health / maxhealth);
    if (entrance) { health = maxhealth; }
    yvel = rvel.evaluate() * 1.0 * rsign;
    if (health / maxhealth < .66 && barrel2) {
      barrel2 = 0;
      real angle = turret_angle + real(1) / 2 * 2 * M_PI + M_PI/2;
      real xval = x + cos(angle) * turret_radius, yval = y + sin(angle) * turret_radius;
      boss2_barrel_explode(xval, yval);
      turrets = 1;
    } else if (health / maxhealth < .33 && barrel1) {
      barrel1 = 0;
      real angle = turret_angle + real(0) / 2 * 2 * M_PI + M_PI/2;
      real xval = x + cos(angle) * turret_radius, yval = y + sin(angle) * turret_radius;
      boss2_barrel_explode(xval, yval);
      turrets = 0;
    }
    if (x < .8 * virtualw) { entrance = 0; x = .8 * virtualw; xvel = 0; }
//    if (turret_stop) { yvel = 0; }
    if (!entrance) { y += yvel * dt; }
    x += xvel * dt;
    if (y < .2) { y = .2; rsign = -rsign; }
    if (y > virtualh - .2) { y = virtualh - .2; rsign = -rsign; }
    turret_angle += .25 * M_PI * dt;
    if (turrets > 0 && turret_angle / M_PI > shot_count) {
      turret_angle = floor(turret_angle / M_PI) * M_PI;
      if (!turret_stop) {
        real xoffset = -virtualw * 0.5 - 0.5 * image_boss[4]->w * virtualw / scr_width;
        real yoffset = (shot_count & 1) ? -turret_radius: turret_radius;
        if (barrel1 || barrel2) { play_sample(sample_wind, 255, get_panning(this), 1000, 1); wind_time = frame_time + .5; }
        if (barrel1) { projectile.add(new boss_laser(this, 30.0, xoffset, yoffset, .5, image_particle4)); }
        yoffset = -yoffset;
        if (barrel2) { projectile.add(new boss_laser(this, 30.0, xoffset, yoffset, .5, image_particle4)); }
        play_sample(sample_shot, 200, get_panning(this), int(400+50*rnd()), 0);
        real velocity = 1;
        int count = 20;
        for (int i = 0; i < count; i++) {
          real theta = M_PI + ((i&1)?(1):(-1))*M_PI/4 + crnd() * M_PI / 4;
          projectile.add(new ion_fire(this, cos(theta) * velocity, sin(theta) * velocity, 104));
        }
        turret_time = frame_time + 1;
        turret_stop = 1;
      }
      else if (turret_stop && frame_time > turret_time) { turret_stop = 0; shot_count++; }
    }
    if (wind_time && frame_time > wind_time) {
      stop_sample(sample_wind);
    }
    for (int i = 0; i < turrets; i++) {
      real angle = turret_angle + real(i) * M_PI + M_PI/2;
      real xval = x + cos(angle) * turret_radius, yval = y + sin(angle) * turret_radius;
      if ((i == 0 && barrel1) || (i == 1 && barrel2)) {
        draw_sprite(buffer, image_boss[4], toScreenX(xval) - image_boss[4]->w / 2, toScreenY(yval) - image_boss[4]->h / 2);
      }
    }
    if (frame_time > fire2_time && !barrel1 && !barrel2) {
//      real velocity = 1;
//      int count = 12;
//      for (int i = 0; i < count; i++) {
//        real theta = M_PI + ((i&1)?(1):(-1))*M_PI/4 + crnd() * M_PI / 4;
//        projectile.add(new ion_fire(this, cos(theta) * velocity, sin(theta) * velocity, 104));
//      }
      fire2_time = frame_time + 2;
    }
    if (!entrance && frame_time > fire1_time) {
      play_sample(sample_shot, 200, get_panning(this), int(400+50*rnd()), 0);
      int count = 4;
      real range = M_PI / 4;
      real base_angle = M_PI - range / 2;
      real velocity = .75;
      for (int i = 0; i < count; i++) {
        real theta = base_angle + i * range / count;
        projectile.add(new ion_fire(this, cos(theta) * velocity, sin(theta) * velocity, 103));
      }
      fire1_time = frame_time + .2;
    }
  }
  void collide(object_type &other) {
    if (&other == player) {
      player->takeDamage(*this, 9999);
    }
  }
  void destroy(object_type &attacker) {
    play_sample(sample_explode, 255, get_panning(this), 800, 0);
    add_score(1000, x, y, 0);
    int count = 32;
    for (real life = 1.0; life <= 4.0; life += 1.00) {
      for (int i = 0; i < count; i++) {
//        real life = 3.0;
        real angle = i*2*M_PI / count;
        real dist = 0.6;
        add_particle(x+dist*cos(angle), y+dist*sin(angle), -dist*cos(angle)/life, -dist*sin(angle)/life, 0, 0,
                     255, 0, 0, 0, .04*pscale,
                     255, 255, 0, 192, .04*pscale,
                     life, image_particle);
      }
    }
    count = (rand() % 15) + 50;
    for (int i = 0; i < count; i++) {
      real xdiff=crnd(),ydiff=crnd();
      real radius=.40*rnd(); //sqrt(rnd())*0.30;
      real r1 = 0.30 * rnd();
      normalize(xdiff,ydiff);
      real xm=xdiff*r1,ym=ydiff*r1;
      xdiff*=radius; ydiff*=radius;
      real life = 3.5+rnd()*2;
      real pxvel = (xdiff - xm) / life, pyvel = (ydiff - ym) / life;
      add_particle(x + xm, y + ym, pxvel, pyvel, 0, 0,
                   255, 128, 64, 255, .10*rnd()*pscale,
                   255, 255, 0, 0, -.10*rnd()*pscale,
                   life, image_particle);
    }
    leveldone_time = frame_time + 4.5;
    remove();
  }
};

void leave_item(object_type *obj, real chance) {
  real x = obj->x, y = obj->y;
  if (rnd() < chance) { item.add(new item_type(obj_health, x, y, 0)); }
  if (rnd() < chance*3/4 && player->can_upgrade()) { item.add(new item_type(obj_weapon, x, y, 0)); }
  if (rnd() < chance/3) { item.add(new item_type(obj_shield, x, y, 0)); }
  if (rnd() < chance/3) { item.add(new item_type(obj_nuke, x, y, 0)); }
}

class asteroid_type: public object_type { public:
  int type, motion_type, points;
  real xvel, yvel, omega;
  asteroid_type(int n, real xval, real yval, int mtype) {
    x = xval; y = yval; yvel = 0;
    do { omega = crnd() * .5; } while (omega < .05 && omega > -.05);
    if (n == 6 && rnd() < .5) { n = 7; }
    switch (type = n) {
      case 6: frame = image_enemy[7]; health = 6; xvel = -.4 + crnd()*.05; points = 10; break;
      case 7: frame = image_enemy[6]; health = 2; xvel = -.4; points = 5; break;
    }
    motion_type = mtype;
    if (mtype > 0) { yvel = crnd() * .25; }
    else { xvel = crnd() * .3; yvel = crnd() * .3; x += xvel * .1; y += yvel * .1; }
  }
  void update() {
    spin += dt * omega;
    x += dt * xvel;
    y += dt * yvel;
    if (y < clip_top) { remove(); return; }
    if (y > clip_bottom) { remove(); return; }
    if (x < clip_left) { remove(); return; }
    if (motion_type == 0) {
      if (x > clip_right) { remove(); return; }
    }
  }
  void collide(object_type &other) {
    if (&other == player) {
      player->takeDamage(*this, type == 6 ? 5: 2);
      destroy(*((object_type *) 0));
    }
  }
  void destroy(object_type &attacker) {
    play_sample(sample_explode2, 255, get_panning(this), int(1000+crnd()*100), 0);
    add_score(points, x, y, xvel);
    if (&attacker) { leave_item(this, .01); }
    int i, count;
    switch (type) {
      case 6:
        count = 2 + (rand() % 3);
        for (i = 0; i < count; i++) {
          hostile.add(new asteroid_type(7, x, y, 0));
        }
        break;
    }
    remove();
  }
};

real laser_time = 0;
class enemy_type: public object_type { public:
  real xvel, yvel, fire_time, ycentral, xcentral, time0, anim_time;
  int type, points, motion_type, fire_toggle;
  int turnaround, damage, can_fire;
  real yorig;
  enemy_type(int n, real yval, int mtype) { xcentral = clip_right; ycentral = yval; fire_toggle = 0;
  fire_time = 0; time0 = frame_time; anim_time = frame_time; yvel = 0; turnaround = 0;
    yorig = ycentral; damage = 2;
    antialias = 1;
    switch (motion_type = mtype) {
      case move_down: yvel = .25; break;
      case move_up: yvel = -.25; break;
      case move_either: yvel = crnd() * .25; break;
    }
    can_fire = 1;
    switch (type = n) {
      case 1: frame = image_enemy[1]; health = 4; xvel = -.6; points = 20; break;
      case 2: frame = image_enemy[2]; health = 1; xvel = -.6; points = 10; can_fire = 0; break;
      case 3: frame = image_enemy[3]; health = 4; xvel = -.3; points = 50; break;
      case 4: frame = image_enemy[4]; health = 4; xvel = -.6; points = 40; break;
      case 5: frame = image_enemy[5]; health = 2; xvel = -.6; points = 20; can_fire = 0; break;
      case 8: frame = image_enemy[8]; health = 9; xvel = -.3; points = 40; can_fire = 0; break;
      case 9: frame = image_enemy[9]; health = 10; xvel = -.3; points = 150; damage = 5; break;
      case 10: frame = image_enemy[10]; health = 2; xvel = -.6; points = 15; can_fire = 0; break;
      case 11: frame = image_enemy[11]; health = 1; xvel = -.9; points = 20; can_fire = 0; break;
      case 12: frame = image_enemy[12]; health = 3; xvel = -.6; points = 50; break;
      case 13: frame = image_enemy[13]; health = 100; damage = 9999; xvel = -.6; points = 100; can_fire = 0; break;
      case 14: frame = image_enemy[14]; health = 3; xvel = -.6; points = 50; break;
      case 15: frame = image_enemy[15]; health = 2; xvel = -.6; points = 30; can_fire = 0; break;
      case 16: frame = image_enemy[16]; health = 5; xvel = -.6; points = 50; break;
      case 17: frame = image_enemy[17]; health = 3; xvel = -.3; points = 50; fire_time = frame_time + 1.8; break;
      case 18: frame = image_enemy[18]; health = 4; xvel = -.6; points = 20; if (ycentral < 1) { spin = .5; } antialias = 0; break;
      case 19: frame = image_enemy[19]; health = 5; xvel = -.3; points = 50; if (motion_type > move_either) { xvel = -.6; } break;
// movetypes: sinwave, squarewave, jigsaw, move_fade_down
// fixme: code the movetypes

// 14 fires paired dots straight ahead and is good for sinwave panning attacks (ion_fire 106)
// 15 does heli-Raptor attack, firing one bullet in its lifetime (ion_fire 107)
// 16 does burst-8 dir dot fire (jigsaw movetype) ion_fire 108
// 17 does p-laser
// 18 fires straight upward and flips vertical if y < 1 (ion_fire 109)
// 19 does vulcan cannon abcbabcba (ion_fire 110)
// movetype move_fade_down: increase xvel to -.9 once x reaches virtualw*2/3
    }
  }
  void collide(object_type &other) {
    if (&other == player) {
      player->takeDamage(*this, damage);
      destroy(*((object_type *) 0));
    }
  }
  void update() {
    xcentral += xvel * dt;
    ycentral += yvel * dt;
    if (motion_type == move_train_up) {
      if (xcentral < .05 && !turnaround) {
        xcentral = .05; yvel = -.6; xvel = 0;
      } else if (ycentral < yorig - 1) {
        ycentral = yorig - 1; yvel = 0; xvel = -.6;
      } else if (ycentral < yorig - .5 && !turnaround) {
        ycentral = yorig - .5; xvel = .6; yvel = 0; turnaround = 1;
      } else if (xcentral > virtualw - .05 && turnaround) {
        xcentral = virtualw - .05; yvel = -.6; xvel = 0;
      }
    } else if (motion_type == move_train_down) {
      if (xcentral < .05 && !turnaround) {
        xcentral = .05; yvel = .6; xvel = 0;
      } else if (ycentral > yorig + 1) {
        ycentral = yorig + 1; yvel = 0; xvel = -.6;
      } else if (ycentral > yorig + .5 && !turnaround) {
        ycentral = yorig + .5; xvel = .6; yvel = 0; turnaround = 1;
      } else if (xcentral > virtualw - .05 && turnaround) {
        xcentral = virtualw - .05; yvel = .6; xvel = 0;
      }
    }

    if (motion_type == move_sine_down) {
      ycentral = yorig - .25 * sin((frame_time - time0) * M_PI/2);
    } else if (motion_type == move_sine_up) {
      ycentral = yorig + .25 * sin((frame_time - time0) * M_PI/2);
    }

    if (motion_type == move_zigzag_down || motion_type == move_zigzag_up) {
      int dir = (motion_type == move_zigzag_down) ? 1: -1;
      if (xcentral < virtualw*.3 && !turnaround) {
        xcentral = virtualw*.3; yvel = dir * .3; xvel = .5; turnaround = 1;
      } else if (xcentral > virtualw*.6 && turnaround) {
        xcentral = virtualw*.6; yvel = 0; xvel = -.6;
      }
    }

    if (motion_type == move_squarewave) {
      real xres = .2;
      if (xcentral < virtualw - xres * turnaround) {
        xcentral = virtualw - xres * turnaround;
        turnaround++;
        yvel = (turnaround & 1) ? .6: -.6;
        xvel = 0;
      } else if (ycentral < yorig - xres / 2) {
        ycentral = yorig - xres / 2;
        yvel = 0;
        xvel = -.6;
      } else if (ycentral > yorig + xres / 2) {
        ycentral = yorig + xres / 2;
        yvel = 0;
        xvel = -.6;
      }
    }

    if (motion_type == move_dart_down || motion_type == move_dart_up) {
      if (xcentral < virtualw*.8) {
        xvel = -.8;
        yvel = (motion_type == move_dart_down) ? -.3: .3;
      }
    }

    if (motion_type == move_squarewave2) {
      real xres = .4;
      if (xcentral < virtualw - xres * turnaround) {
        xcentral = virtualw - xres * turnaround;
        turnaround++;
        yvel = (turnaround & 1) ? .6: -.6;
        xvel = 0;
      } else if (ycentral < yorig - xres / 2) {
        ycentral = yorig - xres / 2;
        yvel = 0;
        xvel = -.6;
      } else if (ycentral > yorig + xres / 2) {
        ycentral = yorig + xres / 2;
        yvel = 0;
        xvel = -.6;
      }
    }

/*
    if (type == 13) {
      BITMAP *img = image_enemy[13];
      draw_sprite(buffer, img, toScreenX(x) - img->w / 2, toScreenY(y) - img->h / 2);
    }
*/

    if (type == 9) {
      spin = atan2(player->y - y, player->x - x) / (2*M_PI) + .5;
    }

    if (xcentral < clip_left || ycentral < clip_top || ycentral > clip_bottom || xcentral > clip_right) { remove(); return; }
    x = xcentral; y = ycentral;

    if (type == 8) {
      if (xcentral <= virtualw * 0.5 && !turnaround) {
        xcentral = virtualw * 0.5;
        xvel = 0;
        real dest_spin = atan2(player->y - y, player->x - x) / (2 * M_PI) + .5;
        dest_spin = dest_spin - floor(dest_spin);
        decay_angle(spin, dest_spin, 1*dt);
        if (spin == dest_spin) {
          turnaround = 1;
          xvel = cos((dest_spin-.5)*2*M_PI) * .7;
          yvel = sin((dest_spin-.5)*2*M_PI) * .7;
        }
      }
    }

    switch (type) {
      case 3:
        x = xcentral + .1*cos(cos(reduce(frame_time - time0)*2*M_PI/2));
        y = ycentral + .1*sin(sin(reduce(frame_time - time0)*2*M_PI/2));
        break;
    }
    if (player->alive && xcentral <= virtualw + .1 && xcentral >= -.1 && frame_time > fire_time && can_fire) {
      play_sample(sample_shot2, 200, get_panning(this), int(300+50*rnd()), 0);
      real angle, xv, yv;
      if (type == 1) {
        angle = atan2(player->y - y, player->x - x) + crnd() * .1;
        xv = cos(angle) * .75;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 101));
      } else if (type == 3) {
        angle = atan2(player->y - y, player->x - x) + .05 + crnd()*.1;
        xv = cos(angle) * .75;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 102));
        angle = atan2(player->y - y, player->x - x) - .05 - crnd()*.1;
        xv = cos(angle) * .75;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 102));
      } else if (type == 4) {
        real xorig = x, yorig = y;
        angle = atan2(player->y - y, player->x - x);
        x = xorig + .025 * sin(angle);
        y = yorig + .025 * cos(angle);
        angle -= .05 + crnd()*.1;
        xv = cos(angle) * .75;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 103));
        angle = atan2(player->y - y, player->x - x) - .05 - crnd()*.1;
        x = xorig + .025 * sin(angle);
        y = yorig + .025 * cos(angle);
        angle += .05 + crnd()*.1;
        xv = cos(angle) * .75;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 103));
        x = xorig; y = yorig;
      } else if (type == 9) {
        real xorig = x, yorig = y;
        angle = atan2(player->y - y, player->x - x);
        x = xorig - .025 * sin(angle);
        y = yorig + .025 * cos(angle);
        xv = cos(angle);
        yv = sin(angle);
        projectile.add(new ion_fire(this, xv, yv, 104));
        x = xorig + .025 * sin(angle);
        y = yorig - .025 * cos(angle);
        xv = cos(angle);
        yv = sin(angle);
        projectile.add(new ion_fire(this, xv, yv, 104));
        x = xorig; y = yorig;
      } else if (type == 12) {
        xv = -1.25; yv = 0;
        projectile.add(new ion_fire(this, xv, yv, 105));
      } else if (type == 14) {
        real yoffset = .025;
        xv = -1.25; yv = 0;
        y -= yoffset;
        projectile.add(new ion_fire(this, xv, yv, 106));
        y += yoffset * 2;
        projectile.add(new ion_fire(this, xv, yv, 106));
        y -= yoffset;
      } else if (type == 16) {
        int sides = 8;
        for (int i = 0; i < sides; i++) {
          double angle = (i+.5) / sides * 2 * M_PI;
          xv = cos(angle) * .75 + xvel;
          yv = sin(angle) * .75;
          projectile.add(new ion_fire(this, xv, yv, 108));
        }
      } else if (type == 17) {
        real xoffset = -virtualw * 0.5 + 0.5 * frame->w * virtualw / scr_width;
        real duration = 1.0;
        if (xcentral > 0) {
          if (!laser_time) {
            play_sample(sample_wind2, 160, 127, 1000, 1);
          }
          laser_time = frame_time + duration;
        }
        projectile.add(new boss_laser(this, 30.0, xoffset, 0, duration, image_particle7));
      } else if (type == 18) {
        xv = xvel; yv = (y > 1) ? -.75: .75;
        projectile.add(new ion_fire(this, xv, yv, 109));
      } else if (type == 19) {
        angle = -M_PI / 4;
        xv = -cos(angle) * .75 + xvel;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 110));

        angle = M_PI / 4;
        xv = -cos(angle) * .75 + xvel;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 110));
/*
        angle = 0;
        xv = -cos(angle) * .75 + xvel;
        yv = sin(angle) * .75;
        projectile.add(new ion_fire(this, xv, yv, 110));
*/
      }
      if (type == 1) {
        fire_time = frame_time + 1 + rnd() * .5;
      } else if (type == 9) {
        if (!fire_toggle) { fire_time = frame_time + .2; } else { fire_time = frame_time + .6; }
        fire_toggle = !fire_toggle;
      } else if (type == 12) {
        fire_time = frame_time + .2 + rnd() * .1;
      } else if (type == 14) {
        fire_time = frame_time + 1;
      } else if (type == 17) {
        fire_time = frame_time + 5;
      } else if (type == 18) {
        fire_time = frame_time + .4 + rnd() * .2;
      } else {
        fire_time = frame_time + .5 + rnd() * .5;
      }
    }
    if (type == 15 && !fire_toggle && x < virtualw * .35) {
      play_sample(sample_shot2, 200, get_panning(this), int(300+50*rnd()), 0);
      real angle = atan2(player->y - y, player->x - x) + crnd() * .1;
      real xv = cos(angle) * .75;
      real yv = sin(angle) * .75;
      projectile.add(new ion_fire(this, xv, yv, 107));
      fire_toggle = 1;
    }
  }
  void destroy(object_type &attacker) {
    if (type == 17) { projectile.remove_by_owner(this); }
    play_sample(sample_explode2, 255, get_panning(this), int(1000+crnd()*100), 0);
    add_score(points, x, y, xvel);
    if (&attacker) { leave_item(this, .02); }
    int count = 50;
//    int count = int(50 * (fps / (max_fps * .65)));
//    int count = int(50 * (fps / (max_fps * .9)));
    real maxrad = 0.16;
//    if (type == 13) { maxrad = 0.50; count = 100; }
    for (int i = 0; i < count; i++) {
      real xdiff=crnd(),ydiff=crnd();
      real radius=rnd()*maxrad;
      real r1 = maxrad/8;
      normalize(xdiff,ydiff);
      real xm=xdiff*r1,ym=ydiff*r1;
      xdiff*=radius; ydiff*=radius;
      real life = 1+rnd()*4;
      real pxvel = (xdiff - xm) / life, pyvel = (ydiff - ym) / life;
      add_particle(x + xm, y + ym, pxvel + xvel, pyvel, 0, 0,
                   255, 255, 64, 255, .05*maxrad/0.16*rnd()*pscale,
                   255, 0, 0, 0, -.01*maxrad/0.16*rnd()*pscale,
                   life, image_particle);
    }
    remove();
  }
};

void fadein_text() { fadein_blur(buffer, .5, .25); }
void fadeout_text() { fadeout_blur(buffer, .5, .25); }
void fadein_menu() { fadein_blur(buffer, .5, 1); }
void fadeout_menu() { fadeout_blur(buffer, .5, 1); }
void fadein_screen() { fadein_blur(buffer, .5, .5); }
void fadeout_screen() { fadeout_blur(buffer, .5, .5); }

void level_reset() {
  world.reset();
  message.reset();
  projectile.reset();
  hostile.reset();
  item.reset();
  world.add(player);
}
real message_wait = 1.0;
void level_message() {
  for (int i = 0; i < buffer_count; i++) {
    clear(buffer);
    textprintf_centre(buffer, message_font, scr_width/2, (scr_height-text_height(message_font))/2, 255,255,255,255, "...entering level%02d...", current_level);
    if (i == 0) { fadein_text(); }
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
  }
}
void finished_message() {
  for (int i = 0; i < buffer_count; i++) {
    clear(buffer);
    textprintf_centre(buffer, message_font, scr_width/2, (scr_height-text_height(message_font)*2)/2, 255,255,255,255, "...level%02d completed...", current_level);
    textprintf_centre(buffer, message_font, scr_width/2, (scr_height+text_height(message_font)*2)/2, 255,255,255,255, "score: %d", player->score);
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
  }
}
void clear_message() {
  fadeout_text();
  clear(buffer);
}
void reset_all() {
  wave_position = 0;
  while (wave[wave_position] < wscroll) {
    wave_position += 4;
  }
  level_reset();
  player->reset();
}

BITMAP *overlay = 0;
void generate_background() {
  if (overlay) { destroy_bitmap(overlay); }
  if (current_level == 4) {
    stars_enabled = 0;
    overlay = create_map(2048, 512);
    return;
  }
  stars_enabled = 1;
  int depth = (current_level == 1) ? 32: 16;
  BITMAP *copy_particle = create_image_ex(depth, image_particle->w, image_particle->h);
  blit(image_particle, copy_particle, 0, 0, 0, 0, image_particle->w, image_particle->h);
#ifdef GL
  overlay = create_image_ex(32, scr_width * 2, scr_height);
#else
  overlay = create_image_ex(32, scr_width * 8, scr_height);
#endif
  if (!overlay) { exit(0); }
  int count = int(5000.0 * overlay->w * overlay->h / 640 / 480);
  real radius = 30;
  if (current_level == 3) { count *= 2; radius *= .7; }
  for (int i = 0; i < count; i++) {
    real x = rnd() * overlay->w;
    real y = rnd() * overlay->h;
    real t = x / overlay->w;
    int red, green, blue;
    hsv_to_rgb(t*360, 1.0, rnd(), &red, &green, &blue);

    add_particle(x, y, 0, 0, 0, 0,
                 red, green, blue, 24, rnd() * radius * pscale,
                 red, green, blue, 24, rnd() * radius * pscale,
                 0.0, copy_particle);
  }
  clear(overlay);
  draw_particles(overlay);
  convert_depth(overlay, bitmap_color_depth(buffer));
  destroy_bitmap(copy_particle);
//  save_bmp("overlay.bmp", overlay, 0);
}

real level_delimit = 1e10;
void load_level() {
  if (wave) { delete[] wave; }
  wave = new real[32768];         // 256k memory
  for (int i = 0; i < message_count; i++) {
    if (global_message[i]) { delete[] global_message[i]; }
  }
  message_count = 0;
  wave_position = 0;
  wscroll = cscroll = 0;
  char filename[256];
  sprintf(filename, "wave%d.dat", current_level);
  FILE *f = fopen(filename, "rb");
  if (!f) { wave[0]=wave[1]=wave[2]=wave[3] = level_delimit; return; }
  real x = 0;
  real *w = wave;
  for (;;) {
    int dx = fgetc(f);
    if (feof(f)) { break; }
    int y = fgetc(f);
    if (feof(f)) { break; }
    int type = fgetc(f);
    if (feof(f)) { break; }
    if (dx == 255 && y == 255 && type == 255) { break; }
    x += dx * .05;
    *w++ = x;
    *w++ = y * .05;
    *w++ = real(type);
    if (type == obj_message) {
      char text[1024];
      char *p = text;
      for (;;) {
        *p = fgetc(f);
        if (*p == '\0') { break; }
        p++;
      }
      *w++ = real(message_count);
      global_message[message_count] = new char[strlen(text) + 1];
      strcpy(global_message[message_count], text);
      message_count++;
    } else {
      *w++ = real(fgetc(f));
    }
  }
  *w++ = level_delimit; *w++ = level_delimit; *w++ = level_delimit; *w++ = level_delimit;
}

MIDI *active_music = 0;
void stop_music() {
  play_midi(0, 0);
  if (active_music) { destroy_midi(active_music); active_music = 0; }
}
void play_music(char *fname = 0) {
  if (active_music) { play_midi(0, 0); destroy_midi(active_music); active_music = 0; }
  char buf[128];
  sprintf(buf, "level%i.mid", current_level);
  active_music = load_midi(fname ? fname: buf);
  play_midi(active_music, 1);
}

void changelevel() {
  stop_music();
  load_level();
  level_message();
  generate_background();
  real message_start = __timer_func();
  while (__timer_func() - message_start < message_wait) { idle_func(); }
  clear_message();
  wscroll = cscroll = 0.0;
  reset_all();
  for (int i = 0; i < 100; i++) {
    add_star(rnd() * virtualw, rnd() * virtualh);
  }
  play_music();
}

extern int num_particles;
extern int particle_capacity;
void process_gameplay() {
  static real comet_time = 0;
  static real life, xvel, yvel;
  static real star_time = 0;
  static real hscroll = 0;
  static real death_time = 0.0, fps_time = 0;
  static int fps_count = 0;

  if (!player) { clear(screen); return; }

  if (overlay) {
    int xoverlay = int(hscroll * scr_width) % overlay->w;
    int yoverlay = toScreenY((ycamera - .5) * 2) % overlay->h;
    blit(overlay, buffer, xoverlay, yoverlay, 0, 0, overlay->w, overlay->h);
    blit(overlay, buffer, xoverlay, yoverlay - overlay->h, 0, 0, overlay->w, overlay->h);
    blit(overlay, buffer, xoverlay - overlay->w, yoverlay, 0, 0, overlay->w, overlay->h);
    blit(overlay, buffer, xoverlay - overlay->w, yoverlay - overlay->h, 0, 0, overlay->w, overlay->h);
  } else {
    clear(buffer);
  }
  hscroll += dt * .075 * scroll_speed;
  wscroll += dt * .5;
  if (leveldone_time && frame_time > leveldone_time) {
    stop_music();
    cscore = player->score;
    finished_message();
    real message_start = __timer_func();
    while (__timer_func() - message_start < message_wait) { idle_func(); }
    current_level++;
    changelevel();
    leveldone_time = 0;
  }

  while (wscroll > wave[wave_position]) {
    if (wave[wave_position + 2] == 0) {
      // ran out of items
      exit(0);
    } else {
      int type = int(wave[wave_position + 2]);
      real yval = wave[wave_position + 1];
      real motion_type = wave[wave_position + 3];
      if (type < 100 && type != 6 && type != 7) {
        hostile.add(new enemy_type(type, yval, int(motion_type)));
      } else if (type < 100) {
        int count = int(motion_type);
        for (int i = 0; i < count; i++) {
          real offset = 2 * .4 / .5 * i / count;
          hostile.add(new asteroid_type(type, clip_right + offset, rnd() * virtualh, 1));
        }
      } else if (type < 200) {
        item.add(new item_type(type, clip_right, yval, motion_type));
      } else if (type == 201) {
        switch (current_level) {
          case 1: hostile.add(new boss1_type()); break;
          case 2: hostile.add(new boss2_type()); break;
          default: hostile.add(new boss1_type()); break;
        }
      }
      wave_position += 4;
    }
  }

  ycamera = player->ycentral;
  clip(ycamera, .5, virtualh - .5);

  if (frame_time - star_time > .05) {
    add_star(virtualw + .045, rnd() * virtualh);
    star_time = frame_time;
  }

  if (frame_time > comet_time && stars_enabled) {
    world.add(new comet_type());
    comet_time = frame_time + 5 + rnd() * 25;
  }

  item.update();
  projectile.update();
  hostile.update();
  draw_particles(buffer, xcamera - virtualw * 0.5, ycamera - .5, xcamera + virtualw * 0.5, ycamera + .5);

  world.collide(world);
  world.collide(projectile);
  world.collide(hostile);
  item.collide(world);
  hostile.collide(projectile);
  world.update();
  message.update();

  char htext[32];
  sprintf(htext, "health: %d", int(ceil(player->health)));
  int indent = scr_width - text_length(message_font, htext);
  textprintf(buffer, message_font, 0, 0, 255, 255, 255, 255, "score: %d", player->score);
  textprintf(buffer, message_font, indent, 0, 255, 255, 255, 255, htext);
  textprintf(buffer, message_font, 0, scr_height - text_height(message_font), 255, 255, 255, 255, "fps: %d", int(fps));
  static int key_d = 0, stats_enabled = 0;
  int prev_d = key_d;
  key_d = key[KEY_D];
  if (key_d && !prev_d) { stats_enabled = !stats_enabled; }
  if (stats_enabled) {
    char buf2[256];
    int count = 0;
    count += world.count;
    count += hostile.count;
    count += projectile.count;
    count += message.count;
    count += item.count;
    sprintf(buf2, "Max fps: %d\nParticles: %d\nWorld: %d\nHostile: %d\nProjectile: %d\nMessage: %d\nItem: %d\nTotal: %d", int(max_fps), particle_count(), world.count, hostile.count, projectile.count, message.count, item.count, count);
    textprintf(buffer, message_font, scr_width - text_length(message_font, "Particles: 1000/1000"), scr_height - text_height(message_font) * 8, 255, 255, 255, 255, buf2);
  }

  if (key[KEY_PAUSE]) {
//      while (key[KEY_PAUSE]) { }
    for (int i = 0; i < buffer_count; i++) {
      draw_sprite(buffer, image_pause, (buffer->w-image_pause->w)/2, (buffer->h-image_pause->h)/2);
      blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
    }
    while (!key[KEY_PAUSE]) { idle_func(); }
    while (key[KEY_PAUSE]) { idle_func(); }
  }

  if (frame_time > fps_time + .5) {
    fps = fps_count / (frame_time - fps_time);
    if (fps > max_fps) { max_fps = fps; }
    fps_time = frame_time;
    fps_count = 0;
  }

  if (!player->alive) {
    if (!death_time) { death_time = frame_time; }
    if (frame_time > death_time + 2.5) {
      death_time = 0.0;
      wscroll = cscroll - .5;
      reset_all();
      level_message();
      real start = __timer_func();
      while (__timer_func() - start < 1.5) { idle_func(); }
      clear_message();
    }
  }
  if (key[KEY_S]) {
    char fname[256];
    for (int i = 1; i < 100; i++) {
      sprintf(fname, "screen%02d.bmp", i);
      if (!file_exists(fname)) { break; }
    }
    save_bmp(fname, buffer, 0);
    key[KEY_S] = 0;
  }
  fps_count++;
  if (!menu_toggle) {
    blit(buffer, screen, 0, 0, 0, 0, scr_width, scr_height);
  } else {
    fadein_screen();
  }
}

int slide_message(char *msg) {
  clear(buffer);
  textout_centre(buffer, message_font, msg, buffer->w/2, (buffer->h-text_height(message_font))/2, 255, 255, 255, 255);
  fadein_text();
  real start_time = __timer_func();
  while (__timer_func() - start_time < 2.5 && !keypressed()) {
    clear(buffer);
    textout_centre(buffer, message_font, msg, buffer->w/2, (buffer->h-text_height(message_font))/2, 255, 255, 255, 255);
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
  }
  fadeout_text();
  return keypressed();
}

void process_menu() {
  static real down_time = 0, up_time = 0;
  static int menu_item = 0;
  clear(buffer);
  int menu_count = 5;
  draw_sprite(buffer, image_menu[0], (scr_width-image_menu[0]->w)/2, (scr_height-image_menu[0]->h)/2);
  if (key[KEY_DOWN] && frame_time > down_time + .1) { menu_item++; if (menu_item > menu_count - 1) { menu_item = menu_count - 1; } down_time = frame_time; }
  if (key[KEY_UP] && frame_time > up_time + .1) { menu_item--; if (menu_item < 0) { menu_item = 0; } up_time = frame_time; }
  BITMAP *img = image_menu[menu_item + 1];
  draw_sprite(buffer, img, (scr_width-img->w)/2, (scr_height-img->h)/2);
  if (menu_toggle) { fadein_menu(); }
  blit(buffer, screen, 0, 0, 0, 0, scr_width, scr_height);
  if (key[KEY_W]) {
    while (keypressed()) { readkey(); }
    while (!keypressed()) { idle_func(); }
    int ch = readkey() & 0xFF;
    if (ch >= '1' && ch <= '9') {
      fadeout_menu();
      current_level = int(ch - '0');
      changelevel();
      // fixme: debugging only
/*
      wscroll = cscroll = 90.0;
      while (wave[wave_position] < wscroll) {
        wave_position += 4;
      }
*/
      menu_toggle = 1;
      menu_active = 0;
    }
  }
  static int cselect = 0;
  int last_select = cselect;
  cselect = key[KEY_ENTER] || fire_button();
  if (!last_select && cselect) {
    while (key[KEY_ENTER] || fire_button()) { idle_func(); }
    if (menu_item == 0) {
      fadeout_menu();
      current_level = 1;
      changelevel();
      player->reset();
      player->die_reset();
      menu_toggle = 1;
      menu_active = 0;
    } else if (menu_item == 1) {
      if (current_level) {
        fadeout_menu();
        menu_active = 0;
        menu_toggle = 1;
      } else {
        // input a level code
      }
    } else if (menu_item == 2) {
      fadeout_menu();
      clear(buffer);
      stop_music();
      blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
      play_music("credits.mid");
      while (keypressed()) { readkey(); }
      for (;;) {
        if (slide_message("Controls")) { break; }
        if (slide_message("Arrow keys move player")) { break; }
        if (slide_message("Control fires weapon")) { break; }
        if (slide_message("Player's health is 20 at maximum")) { break; }
        if (slide_message("Checkpoints save player's progress")) { break; }
        if (slide_message("Health items restore full health")) { break; }
      }
      clear(buffer);
      stop_music();
      blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
      play_music();
      while (keypressed()) { readkey(); }
      menu_toggle = 1;
    } else if (menu_item == 3) {
      fadeout_menu();
      while (keypressed()) { readkey(); }
      char *msg = "Programmed by\nConnelly Barnes\n\nCredits music by\nBenTheKuno!!!";
      clear(buffer);
      stop_music();
      blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
      play_music("credits.mid");
      textout_centre(buffer, message_font, msg, buffer->w/2, (buffer->h-text_height(message_font)*2)/2, 255, 255, 255, 255);
      fadein_screen();
      while (!keypressed()) {
        clear(buffer);
        textout_centre(buffer, message_font, msg, buffer->w/2, (buffer->h-text_height(message_font)*2)/2, 255, 255, 255, 255);
        blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
      }
      readkey();
      fadeout_screen();
      clear(buffer);
      stop_music();
      blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
      play_music();
      menu_toggle = 1;
    } else if (menu_item == 4) {
      do_exit = 1;
    }
  }
}

void process_sound() {
  if (frame_time > laser_time) { stop_sample(sample_wind2); laser_time = 0; }
}

BITMAP *create_v_flip(BITMAP *src) {
  BITMAP *dest = create_bitmap(src->w, src->h);
  for (int y = 0; y < src->h; y++) {
    for (int x = 0; x < src->w; x++) {
      putpixel(dest, x, src->h-1-y, getpixel(src, x, y));
    }
  }
  return dest;
}

int main(int argc, char *argv[]) {
#ifdef GL
  init_all(scr_width, scr_height, 32);
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);
#else
  init_all(scr_width, scr_height, 16);
#ifdef WIN32
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);
#else
  install_sound(DIGI_AUTODETECT, MIDI_MPU, 0);
#endif
#endif
  set_volume(200, 255);
  sample_laser = load_sound("laser.wav");
  sample_laser2 = load_sound("laser2.wav");
  sample_shot = load_sound("shot.wav");
  sample_shot2 = load_sound("shot2.wav");
  sample_item = load_sound("item.wav");
  sample_explode = load_sound("explode.wav");
  sample_explode2 = load_sound("explode2.wav");
  sample_explode3 = load_sound("explode3.wav");
  sample_wind = load_sound("wind.wav");
  sample_wind2 = load_sound("wind.wav");
  sample_activate = load_sound("activate.wav");

  message_font = new font_type("font.bmp");

  current_level = 0;
  int i;
  for (i = 1; i < argc; i++) {
    if (strcmp(argv[i], "-warp") == 0) {
      if (i + 1 < argc) { current_level = atoi(argv[i+1]); menu_active = 0; }
    }
  }

  image_blank_laser = create_image(scr_width, int(scr_height * .08));
  clear(image_blank_laser);

  image_particle = load_image("particle.bmp");
  image_particle2 = load_image("particle2.bmp");
  image_particle3 = load_image("particle3.bmp");
  image_particle4 = load_image("particle4.bmp");
  image_particle5 = load_image("particle5.bmp");
  image_particle5_flip = create_v_flip(image_particle5);

  image_particle6 = load_image("particle6.bmp");
  image_particle7 = load_image("particle7.bmp");
  image_blank_laser2 = create_image(image_particle7->w, image_particle7->h);

  image_particle8 = load_image("particle8.bmp");

  image_ship = load_image("ship.bmp");

  image_item[1] = load_image("item1.bmp");
  image_item[2] = load_image("item2.bmp");
  image_item[3] = load_image("item3.bmp");
  image_item[4] = load_image("item4.bmp");

  image_boss[1] = load_image("boss1.bmp");
  image_boss[2] = load_image("boss2.bmp");
  image_boss[3] = load_image("boss3.bmp");
  image_boss[4] = load_image("boss4.bmp");

  image_star[1] = load_image("star1.bmp");
  image_star[3] = load_image("star3.bmp");
  image_star[4] = load_image("star4.bmp");

  image_enemy[1] = load_image("enemy1.bmp");
  image_enemy[2] = load_image("enemy2.bmp");
  image_enemy[3] = load_image("enemy3.bmp");
  image_enemy[4] = load_image("enemy4.bmp");
  image_enemy[5] = load_image("enemy5.bmp");
  image_enemy[6] = load_image("enemy6.bmp");
  image_enemy[7] = load_image("enemy7.bmp");
  image_enemy[8] = load_image("enemy8.bmp");
  image_enemy[9] = load_image("enemy9.bmp");
  image_enemy[10] = load_image("enemy10.bmp");
  image_enemy[11] = load_image("enemy11.bmp");
  image_enemy[12] = load_image("enemy12.bmp");
  image_enemy[13] = load_image("enemy13.bmp");
  image_enemy[14] = load_image("enemy14.bmp");
  image_enemy[15] = load_image("enemy15.bmp");
  image_enemy[16] = load_image("enemy16.bmp");
  image_enemy[17] = load_image("enemy17.bmp");
  image_enemy[18] = load_image("enemy18.bmp");
  image_enemy[19] = load_image("enemy19.bmp");

  image_menu[0] = load_image("menu.bmp");
  image_menu[1] = load_image("menu1.bmp");
  image_menu[2] = load_image("menu2.bmp");
  image_menu[3] = load_image("menu3.bmp");
  image_menu[4] = load_image("menu4.bmp");
  image_menu[5] = load_image("menu5.bmp");

  image_pause = load_image("pause.bmp");

  image_dot = create_image(20, 20);
  clear(image_dot);

  player = new player_type();
  if (!menu_active && current_level) {
    changelevel();
  }

  play_music();
  xcamera = virtualw * 0.5;
  ycamera = 0.5;
  real last_frame = __timer_func();
  int escape = 0, prev_esc;
  while (!do_exit) {
    frame_time = __timer_func();
    dt = frame_time - last_frame;
    if (dt > .05) { dt = .05; }
    last_frame = frame_time;

    if (key[KEY_X]) { do_exit = 1; }
    prev_esc = escape;
    escape = key[KEY_ESC];
    if (escape && !prev_esc && current_level) { menu_active = !menu_active; menu_toggle = 1; if (menu_active) { fadeout_screen(); } else { fadeout_menu(); } }
    int old_toggle = menu_toggle;
    if (menu_active || !current_level) {
      process_menu();
    } else {
      process_gameplay();
    }
    process_sound();
    if (old_toggle) { menu_toggle = 0; }
  }
#ifndef GL
#ifndef WIN32
  stop_music();
  set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
#endif
#endif
  return 0;
}

#ifdef END_OF_MAIN
END_OF_MAIN()
#endif
