
#ifndef __particle_h
#define __particle_h

#include <allegro.h>
#include <stdlib.h>
#ifndef rnd
#define rnd() (((rand() ^ rand()) / ((double) RAND_MAX + 1.0)))
#endif
#ifndef crnd
#define crnd() (rnd() * 2.0 - 1.0)
#endif

void add_particle(double x, double y, double xvel, double yvel, double xaccel, double yaccel,
                  double red1, double green1, double blue1, double opacity1, double radius1,
                  double red2, double green2, double blue2, double opacity2, double radius2,
                  double life, BITMAP *texture);

void draw_particles(BITMAP *bmp, double=0.0, double=0.0, double=0.0, double=0.0);
void draw_particles_caller(BITMAP *bmp, double, double, double, double, void (*cb)(BITMAP *, BITMAP *, int, int, int, int, int, int, int, int));

int particle_count();
int particle_usage();

#include <math.h>
#include <string.h>

typedef double real;

volatile long __particle_timer = 0;
void __inc_particle_timer() { __particle_timer++; }
END_OF_FUNCTION(__inc_particle_timer);

real __frame_time = 0;
int __system_initialized = 0;

class p_attribute { public:
  real r, g, b, alpha, radius;
};

class particle_type { public:
  real x, y, x_initial, y_initial, xvel, yvel, xaccel, yaccel;
  p_attribute initial, final, current;
  real start_time, life;
  BITMAP *image;
  particle_type *next, *prev;
  int update() {
    if (__frame_time > start_time + life) { return 0; }
    real t = __frame_time - start_time;
    x = 0.5 * xaccel * t * t + xvel * t + x_initial;
    y = 0.5 * yaccel * t * t + yvel * t + y_initial;
    real v = t / (life ? life: 1.0), u = 1 - v;
    current.r      = fabs( u * initial.r      + v * final.r      );
    current.g      = fabs( u * initial.g      + v * final.g      );
    current.b      = fabs( u * initial.b      + v * final.b      );
    current.alpha  = fabs( u * initial.alpha  + v * final.alpha  );
    current.radius = fabs( u * initial.radius + v * final.radius );
    return 1;
  }
};

particle_type *__first = 0;
int __particle_count = 0;
double view_x1, view_y1, view_xscale, view_yscale;

void add_particle(real x, real y, real xvel, real yvel, real xaccel, real yaccel,
                  real r1, real g1, real b1, real alpha1, real radius1,
                  real r2, real g2, real b2, real alpha2, real radius2,
                  real life, BITMAP *image) {
  if (!image || image->w <= 0 || image->h <= 0 || life < 0) { return; }
  __particle_count++;
  particle_type *current = new particle_type;
  current->prev = 0;
  current->next = __first;
  if (__first) { __first->prev = current; }
  __first = current;
  current->x_initial = x;
  current->y_initial = y;
  current->xvel = xvel;
  current->yvel = yvel;
  current->xaccel = xaccel;
  current->yaccel = yaccel;
  current->initial.r = r1;
  current->initial.g = g1;
  current->initial.b = b1;
  current->initial.alpha = alpha1;
  current->initial.radius = radius1;
  current->final.r = r2;
  current->final.g = g2;
  current->final.b = b2;
  current->final.alpha = alpha2;
  current->final.radius = radius2;
  current->start_time = __frame_time;
  current->life = life;
  current->image = image;
  current->current.r      = fabs(current->initial.r);
  current->current.g      = fabs(current->initial.g);
  current->current.b      = fabs(current->initial.b);
  current->current.alpha  = fabs(current->initial.alpha);
  current->current.radius = fabs(current->initial.radius);
}

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;

#ifndef u_getr15
#define u_getr15(c) (((c) >> 10) & 0x1F)
#define u_getg15(c) (((c) >>  5) & 0x1F)
#define u_getb15(c) ((c) & 0x1F)
#define u_makecol15(r, g, b) (((r) << 10) | ((g) << 5) | (b))
#define u_rmax15 31
#define u_gmax15 31
#define u_bmax15 31
#define u_readcol15(lineptr, x) (*((uint16 *) ((lineptr) + ((x)<<1))))
#define u_readcol_mask15(lineptr, x) u_readcol15(lineptr, x)
#define u_writecol15(lineptr, x, col) *((uint16 *) ((lineptr) + ((x)<<1))) = (col)

#define u_getr16(c) (((c) >> 11) & 0x1F)
#define u_getg16(c) (((c) >>  5) & 0x3F)
#define u_getb16(c) ((c) & 0x1F)
#define u_makecol16(r, g, b) (((r) << 11) | ((g) << 5) | (b))
#define u_rmax16 31
#define u_gmax16 63
#define u_bmax16 31
#define u_readcol16(lineptr, x) (*((uint16 *) ((lineptr) + ((x)<<1))))
#define u_readcol_mask16(lineptr, x) u_readcol16(lineptr, x)
#define u_writecol16(lineptr, x, col) *((uint16 *) ((lineptr) + ((x)<<1))) = (col)

#define u_getr24(c) (((c) >> 16) & 0xFF)
#define u_getg24(c) (((c) >>  8) & 0xFF)
#define u_getb24(c) ((c) & 0xFF)
#define u_makecol24(r, g, b) (((r) << 16) | ((g) << 8) | (b))
#define u_rmax24 255
#define u_gmax24 255
#define u_bmax24 255
#define u_readcol24(lineptr, x) *((int *) ((char *) (lineptr) + (x) * 3))
#define u_readcol_mask24(lineptr, x) (u_readcol24(lineptr, x) & 0xFFFFFF)
inline void u_writecol24(uint8 *lineptr, int x, int col) {
  *((uint16 *) (lineptr+x*3)) = col & 0xFFFF;
  *((uint8 *) (lineptr+x*3+2)) = col >> 16;
}

#define u_getr32(c) (((c) >> 16) & 0xFF)
#define u_getg32(c) (((c) >>  8) & 0xFF)
#define u_getb32(c) ((c) & 0xFF)
#define u_makecol32(r, g, b) (((r) << 16) | ((g) << 8) | (b))
#define u_rmax32 255
#define u_gmax32 255
#define u_bmax32 255
#define u_readcol32(lineptr, x) (*((uint32 *) ((lineptr) + ((x)<<2))))
#define u_readcol_mask32(lineptr, x) u_readcol32(lineptr, x)
#define u_writecol32(lineptr, x, col) *((uint32 *) ((lineptr) + ((x)<<2))) = (col)
#endif

void render_particle(BITMAP *bmp, BITMAP *img, int x1, int y1, int x2, int y2, int red, int green, int blue, int alpha) {
  int dx = ((img->w) << 16) / (x2 - x1);
  int dy = ((img->h) << 16) / (y2 - y1);
  int x1src = 0, y1src = 0;
  if (x1 < bmp->cl) { x1src = dx * (bmp->cl - x1); x1 = bmp->cl; }
  if (y1 < bmp->ct) { y1src = dy * (bmp->ct - y1); y1 = bmp->ct; }
  if (x2 > bmp->cr) { x2 = bmp->cr; }
  if (y2 > bmp->cb) { y2 = bmp->cb; }
  if (x1 >= x2) { return; }
  if (y1 >= y2) { return; }
  int rmul = red * alpha / 256;
  int gmul = green * alpha / 256;
  int bmul = blue * alpha / 256;
  int rval, gval, bval;
  int depth = bitmap_color_depth(bmp);
  if (depth == 15) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol15(srcline, xsrc >> 16);
        if (!(c2 & ~u_makecol15(1, 1, 1))) { continue; }
        int c1 = u_readcol15(dstline, x);
        rval = u_getr15(c1) + (u_getr15(c2) * rmul >> 8);
        gval = u_getg15(c1) + (u_getg15(c2) * gmul >> 8);
        bval = u_getb15(c1) + (u_getb15(c2) * bmul >> 8);
        if (rval & (~u_rmax15)) { rval = u_rmax15; }
        if (gval & (~u_gmax15)) { gval = u_gmax15; }
        if (bval & (~u_bmax15)) { bval = u_bmax15; }
        u_writecol15(dstline, x, u_makecol15(rval, gval, bval));
      }
    }
  } else if (depth == 16) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol16(srcline, xsrc >> 16);
        if (!(c2 & ~u_makecol16(1, 1, 1))) { continue; }
        int c1 = u_readcol16(dstline, x);
        rval = u_getr16(c1) + (u_getr16(c2) * rmul >> 8);
        gval = u_getg16(c1) + (u_getg16(c2) * gmul >> 8);
        bval = u_getb16(c1) + (u_getb16(c2) * bmul >> 8);
        if (rval & (~u_rmax16)) { rval = u_rmax16; }
        if (gval & (~u_gmax16)) { gval = u_gmax16; }
        if (bval & (~u_bmax16)) { bval = u_bmax16; }
        u_writecol16(dstline, x, u_makecol16(rval, gval, bval));
      }
    }
  } else if (depth == 24) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol24(srcline, xsrc >> 16);
        if (!(c2 & ~u_makecol24(4, 4, 4))) { continue; }
        int c1 = u_readcol24(dstline, x);
        rval = u_getr24(c1) + (u_getr24(c2) * rmul >> 8);
        gval = u_getg24(c1) + (u_getg24(c2) * gmul >> 8);
        bval = u_getb24(c1) + (u_getb24(c2) * bmul >> 8);
        if (rval & (~u_rmax24)) { rval = u_rmax24; }
        if (gval & (~u_gmax24)) { gval = u_gmax24; }
        if (bval & (~u_bmax24)) { bval = u_bmax24; }
        u_writecol24(dstline, x, u_makecol24(rval, gval, bval));
      }
    }
  } else if (depth == 32) {
    for (int y = y1, ysrc = y1src; y < y2; y++, ysrc += dy) {
      uint8 *dstline = bmp->line[y];
      uint8 *srcline = img->line[ysrc >> 16];
      for (int x = x1, xsrc = x1src; x < x2; x++, xsrc += dx) {
        int c2 = u_readcol32(srcline, xsrc >> 16);
        if (!(c2 & (~u_makecol24(4, 4, 4) & 0xFFFFFF))) { continue; }
        int c1 = u_readcol32(dstline, x);
        rval = u_getr32(c1) + (u_getr32(c2) * rmul >> 8);
        gval = u_getg32(c1) + (u_getg32(c2) * gmul >> 8);
        bval = u_getb32(c1) + (u_getb32(c2) * bmul >> 8);
        if (rval & (~u_rmax32)) { rval = u_rmax32; }
        if (gval & (~u_gmax32)) { gval = u_gmax32; }
        if (bval & (~u_bmax32)) { bval = u_bmax32; }
        u_writecol32(dstline, x, u_makecol32(rval, gval, bval));
      }
    }
  }
}

void check_init() {
  if (!__system_initialized) {
    __system_initialized = 1;
    install_timer();
    LOCK_VARIABLE(__particle_timer);
    LOCK_FUNCTION(__inc_particle_timer);
    install_int_ex(__inc_particle_timer, BPS_TO_TIMER(1000));
  }
}

void draw_particles_caller(BITMAP *bmp, double x1, double y1, double x2, double y2, void (*cb)(BITMAP *, BITMAP *, int, int, int, int, int, int, int, int)) {
  if (!x1 && !x2 && !y1 && !y2) { x2 = bmp->w; y2 = bmp->h; }
  if (x1 == x2 || y1 == y2) { return; }
  view_x1 = x1;
  view_y1 = y1;
  view_xscale = bmp->w / (x2 - x1);
  view_yscale = bmp->h / (y2 - y1);
  check_init();
  particle_type *current = __first;
  while (current) {
    particle_type *next = current->next;
    if (current->update()) {
      double rad = current->current.radius * view_xscale;
      double px = (current->x - view_x1) * view_xscale;
      double py = (current->y - view_y1) * view_yscale;
      double aspect = double(current->image->h) / current->image->w;
      int x1 = int(px - rad), y1 = int(py - rad * aspect);
      int x2 = int(px + rad), y2 = int(py + rad * aspect);
      if (x2 > x1 && y2 > y1) {
        cb(bmp, current->image, x1, y1, x2, y2, int(current->current.r), int(current->current.g), int(current->current.b), int(current->current.alpha));
      }
    } else {
      if (current->next) { current->next->prev = current->prev; }
      if (current->prev) { current->prev->next = current->next; }
      if (current == __first) { __first = next; }
      delete current;
      __particle_count--;
    }
    current = next;
  }
  __frame_time = __particle_timer / 1000.0;
}

void draw_particles(BITMAP *bmp, double x1, double y1, double x2, double y2) {
  draw_particles_caller(bmp, x1, y1, x2, y2, &render_particle);
}

int particle_count() { return __particle_count; }

#endif /* __particle_h */

