/********************************************************
* 
*********************************************************/


#include <allegro.h>
#include "graphic.h"
#include "example.h"

allcards *newlist;
cardslist *mcards, *rcards;
player *mplayer, *rplayer;
bfield *bf;
int lasteater, countdisp, rpoints, mpoints;
card *lastplayed;
DATAFILE *datafile;
FONT *original_font;
DIALOG the_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)                    (d2)  (dp)              (dp2) (dp3) */
   { d_button_proc,     360,  400,  161,  49,   255,  0,    0,    D_EXIT,  0,                      0, (void *)"Continue",         NULL, NULL  },
   { d_button_proc,     80,   400,  161,  49,   255,  0,    0,    D_EXIT,  0,                      0, (void *)   "Quit",             NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,                      0,    NULL,             NULL, NULL  }
};

void display()
{
  
  mplayer->drawcards(2,0);
  rplayer->drawcards(382);
  bf->drawcards();
  mcards->drawscore(25);
  mplayer->drawpoints(50);
  rcards->drawscore(409);
  rplayer->drawpoints(434);
  if (countdisp == 0){
    rplayer->drawronda(412);
    mplayer->drawronda(29);
  }
}

void display(int pos)
{
  mplayer->drawcards(2,pos);
  rplayer->drawcards(382);
  bf->drawcards();
  mcards->drawscore(25);
  mplayer->drawpoints(50);
  rcards->drawscore(409);
  rplayer->drawpoints(434);
  if (countdisp == 0){
	rplayer->drawronda(412);
    mplayer->drawronda(29);
  }
}

void delfiles()
{
  remove("bfield.dat");
  remove("rplayer.dat");
}

void read()
{
    FILE *fich;
	struct posit posd;
	if ((fich=fopen("bfield.dat","rb"))==NULL)
	  printf("Error: opening bfield.dat\n");
	while(fread(&posd,sizeof(posd),1,fich)){
      printf("%d %d %d\n",posd.pos,posd.number,posd.used);
	}
	fclose(fich);
}

void firstpg()
{
  textout_centre(screen, font, "RONDA CARD GAME", 320, 210, 1);
  textout_centre(screen, font, "GNU General Public License (GPL)", 320, 230, 7);
  textout_centre(screen, font, "(C) 2001 - 2002 Karim Zerioh", 320, 250, 7);
  textout_centre(screen, font, "zerioh@programmer.net", 320, 270, 8);
}

void lastpg(){
  textprintf_centre(screen, font, 250, 200, 5, "Final result ");
  mcards->drawscore(25);
  mplayer->drawpoints(50);
  rcards->drawscore(409);
  rplayer->drawpoints(434);
  textprintf(screen, font, 400, 160, 5, "%d", mpoints);
  textprintf(screen, font, 400, 240, 5, "%d", rpoints);
}

int main(int argc, char *argv[])
{
  char buf1[256], buf2[80], buf3[80];
  int rvalue, ret;
  card* crd=new card();
  lastplayed = new card();
  card* vrt=new card();
  selectedlist *selist, *selist1;
  listpos *lpos;
  struct finpos *foundpos;
  pos_t *result;
  selected* sel=new selected();
  int pos,bfpos,length;
  allegro_init();
  install_keyboard(); 
  if (set_gfx_mode(GFX_AUTODETECT, 640, 480 , 0, 0) != 0) {
       set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
       allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
       return 1;
  }
  set_palette(desktop_palette);
  set_color_depth(24);
  install_mouse();
  install_timer();
  firstpg();
  if ((readkey() & 0xff) == 27)
      exit(0);
  continu:
  rpoints = 0; mpoints = 0;
  rcards=new cardslist();
  mcards=new cardslist();
  newlist=new allcards();
  newlist->fill();
  newlist=newlist->randomi();
  bf=newlist->bgive();
  while(newlist->getlength()){
   lastplayed->settozero();
   mplayer=newlist->give(mpoints);
   mplayer->setronda(0);
   mplayer->setronda(mplayer->isronda());
   rplayer=newlist->give(rpoints);
   rplayer->setronda(0);
   rvalue = rplayer->isronda();
   rplayer->refresh();
   bf->refresh();
   clear(screen);
   display();
   length=mplayer->getlength();
   countdisp = 0;
   while(length){
	 //real player in action
	 lpos=rinaction();
     selist=lpos->selist;
	 crd=rplayer->delet(rplayer->convert(lpos->rpos));
	 if (selist->length)
     {
       rcards->addinque(crd);
       sel=selist->first;
       int i=0;
	   while(sel){
	     crd=new card();
         bf=bf->sort();
         crd=bf->delet(bf->convert(sel->num));
		 if (!i)
		  if (compare(crd,lastplayed)){
			 alert("ESTE",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
			 rplayer->addpoint(1);
             rpoints++;
		  }
		 bf->refresh();
		 rcards->addinque(crd);
	     sel=sel->next;
	     i++;
	   } 
	   lasteater=0;
	   lastplayed = crd;
     }
     else {
       bfpos=lpos->pos;
	   bf->addinque(crd,bfpos);
	   lastplayed=crd;
	   bf->refresh();
     }
	 delete(sel);
     rplayer->refresh();
	 if (!bf->getlength()){
		alert("MESA",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
	    rplayer->addpoint(1);
		rpoints++;
	 }
	 if ((readkey() & 0xff) == 27)
	   exit(0);
	 clear(screen);
     display();
	 
	 //master player in action
	 foundpos=mplayer->findpos();
	 if ((readkey() & 0xff) == 27)
	   exit(0);
     clear(screen);
	 display(foundpos->result->pos);
	 result=mplayer->play(foundpos);
     crd=mplayer->delet(result->pos);
     lastplayed = crd;
     if (result->eaten){
         mcards->addinque(crd);
		 lasteater=1;
	 }
	 bf->refresh();
	 if (!bf->getlength()){
		alert("MESA",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
	    mplayer->addpoint(1);
		mpoints++;
	 }
	 if ((readkey() & 0xff) == 27)
	   exit(0);
	 countdisp++;
	 length=mplayer->getlength();
	 if (!length){
	   if ((rplayer->getronda())&&(mplayer->getronda())){
		  if (rvalue == 0)
		      alert("You made a mistake","You have no ronda",NULL,"OK",NULL,KEY_ENTER, 0);
	      if (rvalue > mplayer->getronda()){
            alert("RONDA for you",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
	        rplayer->addpoint(2);
		    rpoints = rpoints+2;
	      }
		  else if (rvalue == mplayer->getronda())
                   alert("RONDA for you",NULL,NULL,"OK",NULL,KEY_ENTER, 0);		  
		       else{
				   alert("RONDA for me",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
	               mplayer->addpoint(2);
		           mpoints = mpoints + 2;
			   }
	   }
	   else{
	    if (rplayer->getronda()){
		  if (rvalue == 0)
		      alert("You made a mistake","You have no ronda",NULL,"OK",NULL,KEY_ENTER, 0);
		  else{
            alert("RONDA for you",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
	        rplayer->addpoint(1);
		    rpoints++;
		  }
	    }
        if (mplayer->getronda()){
          alert("RONDA for me",NULL,NULL,"OK",NULL,KEY_ENTER, 0);
	      mplayer->addpoint(1);
		  mpoints++;
	    }
       }//else   
	 }//if (!length)     
     clear(screen);
	 display();
   }//end while(length)
   countdisp = 0;
  }//end while(newlist->getlength())
  readkey();
  clear(screen);
  while(bf->getlength()){
    crd=bf->delet(1);
    if (lasteater)
      mcards->addinque(crd);
    else
      rcards->addinque(crd);
  }
  int lgth = mcards->getlength();
  if (lgth > 20){
      mpoints = mpoints + lgth - 20;
	  //mplayer->setpoints(mpoints);
  }
  lgth = rcards->getlength();
  if (lgth > 20){
      rpoints = rpoints + lgth - 20;
	  //rplayer->setpoints(rpoints);
  }
  lastpg();
  readkey();
  clear(screen);
  if (rpoints > mpoints)
	  textprintf_centre(screen, font, SCREEN_W/2, SCREEN_H/2, 5, "Congratulations! You are the winner! ");
  if (rpoints < mpoints)
	  textprintf_centre(screen, font, SCREEN_W/2, SCREEN_H/2, 5, "Next time perhaps!");
  delete(crd);
  delfiles();
  datafile = load_datafile("example.dat");
   if (!datafile) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error loading : example.dat!\n");
      return 1;
   }
   original_font = font;
   ret = do_dialog(the_dialog, -1);
   if (ret==0)
	  goto continu;
   unload_datafile(datafile);
  return 0; 
}
END_OF_MAIN();