/* weapon-pick.c,
 *
 * Automatic weapon selection.  We are assuming clients have the
 * correct ammo for each weapon.
 */

#include <assert.h>
#include "weapon-pick.h"
#include "weapon.h"


bool is_new_weapon[NUM_WEAPON_CLASSES];
bool is_new_ammo[NUM_WEAPON_CLASSES];

/*--------------------------------------------------------------*/

static bool is_better(const enum WEAPON_CLASS a, const enum WEAPON_CLASS b)
{
    return (a > b);
}


/* weapon_pick:
 *
 * Pick a weapon after we found some of gun/ammo.
 */
enum WEAPON_CLASS weapon_pick(const player_t *p)
{
    enum WEAPON_CLASS w, best;

    if (weapon_is_explosive(p->weapon))
	return p->weapon;

    best = p->weapon;
    for (w = WEAPON_FIRST; w < NUM_WEAPON_CLASSES; w++) {
	if (!p->have_weapon[w] ||
	    (p->weapon_ammo[w] <= 0) ||
	    (weapon_is_explosive(w)) ||
	    !is_better(w, best))
	    continue;

	if ((is_new_weapon[w]) ||
	    (is_new_ammo[w]))
	    best = w;
    }

    return best;
}


/* weapon_pick_no_ammo:
 *
 * Suggest a weapon if we have no ammo for the current gun.
 */
enum WEAPON_CLASS weapon_pick_no_ammo(const player_t *p)
{
    enum WEAPON_CLASS w;

    for (w = WEAPON_MINIGUN; w > WEAPON_BLASTER; w--) {
	if ((p->have_weapon[w]) &&
	    (p->weapon_ammo[w] > 0))
	    return w;
    }

    return WEAPON_BLASTER;
}

/*--------------------------------------------------------------*/

void weapon_pick_reset(void)
{
    enum WEAPON_CLASS w;

    for (w = WEAPON_FIRST; w < NUM_WEAPON_CLASSES; w++) {
	is_new_weapon[w] = false;
	is_new_ammo[w] = false;
    }
}
