/* stats-pickup.c,
 *
 * Extra stats about individual pickups.
 */

#include <assert.h>
#include "stats-pickup.h"


#define SKIP_WEAPON		{ WEAPON_BLASTER, 0 }
#define SKIP_POWERUP		{ POWERUP_BERSERKER, 0 }

#define ADD_WEAPON(t,s,w,a)	{ t, PICKUP_WEAPON,  s, 0, {{w,a},SKIP_POWERUP} }
#define ADD_AMMO(t,s,w,a)	{ t, PICKUP_AMMO,    s, 0, {{w,a},SKIP_POWERUP} }
#define ADD_HEALTH(t,s,h)	{ t, PICKUP_HEALTH,  s, h, {SKIP_WEAPON,SKIP_POWERUP} }
#define ADD_POWERUP(t,s,p,d)	{ t, PICKUP_POWERUP, s, 0, {SKIP_WEAPON,{p,d}} }

const pickup_stats_t pickup_stats[NUM_PICKUP_CLASSES] = {
    /*  0- 6: Weapons */
    ADD_WEAPON(    0, 'B', WEAPON_BLASTER,		 0),
    ADD_WEAPON( 4000, 'S', WEAPON_SHOTGUN,		 8),
    ADD_WEAPON( 4000, 'V', WEAPON_VULCAN,		25),
    ADD_WEAPON( 5000, 'M', WEAPON_MINIGUN,		30),
    ADD_WEAPON( 6000, 'N', WEAPON_MICRO_MISSILE,	 5),
    ADD_WEAPON(10000, 'R', WEAPON_MISSILE_LAUNCHER,	 2),
    ADD_WEAPON( 8000, 'G', WEAPON_GRENADE_LAUNCHER,	 3),
    
    /*  7-13: Ammo */
    ADD_AMMO(    0, 'b', WEAPON_BLASTER,		 0),
    ADD_AMMO( 3000, 's', WEAPON_SHOTGUN,		12),
    ADD_AMMO( 3000, 'v', WEAPON_VULCAN,			60),
    ADD_AMMO( 3000, 'm', WEAPON_MINIGUN,	        80),
    ADD_AMMO( 3000, 'n', WEAPON_MICRO_MISSILE,		20),
    ADD_AMMO( 3000, 'r', WEAPON_MISSILE_LAUNCHER,	 5),
    ADD_AMMO( 3000, 'g', WEAPON_GRENADE_LAUNCHER,	10),

    /* 14-15: Health */
    ADD_HEALTH( 5000, '-', 25),
    ADD_HEALTH(15000, '+', 50),

    /* 16-20: Powerups */
    ADD_POWERUP(30000, 'l', POWERUP_BERSERKER,	30000),
    ADD_POWERUP(25000, 'L', POWERUP_LASER,	60000),
    ADD_POWERUP(20000, 'a', POWERUP_LIGHT_AMP,	45000),
    ADD_POWERUP(30000, 'c', POWERUP_STEALTH,	30000),
    ADD_POWERUP(30000, 't', POWERUP_TRACKER,	45000)
};

#undef ADD_POWERUP
#undef ADD_HEALTH
#undef ADD_AMMO
#undef ADD_WEAPON
#undef SKIP_POWERUP
#undef SKIP_WEAPON

const sprite_t pickup_sprite[NUM_PICKUP_CLASSES] = {
    /*  0- 6: Weapons */
    { 180,   2, 43, 20 },
    {   2,  34, 84, 16 },
    {  89,  34, 80, 27 },
    { 172,  34, 68, 28 },
    {  74,   2, 50, 27 },
    {   2,   2, 69, 29 },
    { 127,   2, 50, 22 },

    /*  7-13: Ammo */
    { 101,  65, 13, 19 },
    { 117,  65, 25, 15 },
    { 145,  65, 23, 23 },
    { 171,  65, 37, 21 },
    {  65,  65, 33, 17 },
    {   2,  65, 47, 30 },
    {  52,  65, 10, 16 },

    /* 14-15: Health */
    {   0,   0,  1,  1 },
    {   2,  98, 40, 30 },

    /* 16-20: Powerups */
    {  45,  98, 18, 26 },
    {  66,  98, 30, 16 },
    { 143,  98, 35, 18 },
    {   0,   0,  1,  1 },
    {  99,  98, 40, 28 }
};

/*--------------------------------------------------------------*/

enum PICKUP_CLASS pickup_class_from_symbol(const char symbol)
{
    enum PICKUP_CLASS p;

    for (p = 0; p < NUM_PICKUP_CLASSES; p++) {
	if (pickup_stats[p].symbol == symbol)
	    return p;
    }

    return PICKUP_WEAPON_BLASTER;
}


char pickup_class_to_symbol(const enum PICKUP_CLASS p)
{
    assert(p < NUM_PICKUP_CLASSES);

    return pickup_stats[p].symbol;
}
