/* stats-meat.c,
 *
 * Extra stats about different meat types.
 */

#include <assert.h>
#include <stdlib.h>
#include "stats-meat.h"


static const struct {
    enum MEAT_CLASS lower, upper;
} category[NUM_MEAT_CATEGORIES] = {
    { MEAT_PLAYER1,	MEAT_PLAYER4 },
    { MEAT_BARREL1,	MEAT_BARREL3 },
    { MEAT_BARREL_RED1,	MEAT_BARREL_RED3 },
    { MEAT_CRATE1,	MEAT_CRATE3 }
};

const unsigned int meat_spawn_num[NUM_MEAT_CATEGORIES] = {
    /* Meat */
    15, 

    /* Barrels */
    8, 8,

    /* Crates */
    10
};

#define NO_PARTICLES		{false, PARTICLE_BLOOD}

const meat_stats_t meat_stats[NUM_MEAT_CLASSES] = {
    /* Meat */
    { 10000, 10000, 125,  50, 0.25, {true, PARTICLE_BLOOD} },
    { 11000, 11000, 150,  50, 0.25, {true, PARTICLE_BLOOD} },
    { 12000, 12000, 175,  50, 0.20, {true, PARTICLE_BLOOD} },
    { 12000, 12000, 100,  50, 0.20, {true, PARTICLE_BLOOD} },

    /* Barrels */
    {  6000,  5000, 400, 100, 0.15, NO_PARTICLES },
    {  5500,  5500, 425, 125, 0.20, NO_PARTICLES },
    {  5000,  6000, 450, 150, 0.25, NO_PARTICLES },
    {  6000,  5000, 400, 100, 0.15, NO_PARTICLES },
    {  5500,  5500, 425, 125, 0.20, NO_PARTICLES },
    {  5000,  6000, 450, 150, 0.25, NO_PARTICLES },

    /* Crates */
    {  7500,  7500, 125,  50, 0.10, NO_PARTICLES },
    {  8000,  8000, 150,  75, 0.15, NO_PARTICLES },
    {  8500,  8500, 175, 100, 0.20, NO_PARTICLES }
};

#undef NO_PARTICLES

const sprite_t meat_sprite[NUM_MEAT_CLASSES] = {
    /* Meat */
    {  2,  2, 12,  9 },
    { 17,  2, 12,  8 },
    { 32,  2, 12, 10 },
    { 47,  2, 17, 10 },

    /* Barrels */
    {  2, 15, 16, 11 },
    { 21, 15, 16, 12 },
    { 40, 15, 14, 11 },
    {  2, 30, 16, 11 },
    { 21, 30, 16, 12 },
    { 40, 30, 14, 11 },

    /* Crates */
    {  2, 45, 22,  7 },
    { 27, 45, 14, 13 },
    { 44, 45, 20,  9 }
};

/*--------------------------------------------------------------*/

enum MEAT_CLASS meat_class_from_category(const enum MEAT_CATEGORY cat)
{
    int range;
    assert(cat < NUM_MEAT_CATEGORIES);

    range = category[cat].upper - category[cat].lower + 1;
    assert(range > 0);
    
    return (category[cat].lower + rand()%range);
}
