/* sprite.c,
 *
 * Some common sprite type definitions and functions.
 */

#include <assert.h>
#include "common.h"
#include "sprite.h"


/*--------------------------------------------------------------*/

void sprite_tint_col(const bool highlight, const bool hidden,
		     const GLfloat **last_col)
{
    const GLfloat *col;

    if (highlight)
	col = glHoverCol;
    else if (hidden)
	col = glGray25;
    else
	col = glWhite;

    if (col != *last_col) {
	glColor3fv(col);
	*last_col = col;
    }
}

/*--------------------------------------------------------------*/

/* texcoord_from_sprite:
 *
 * Given a sprite and the bitmap size, fill in the texture coordinates
 * suitable for use for 'gl_draw_sprite'.
 *
 * Assume the sprites are drawn in double size.
 */
void texcoord_from_sprite(texcoord2d_t *coord, const sprite_t *sprite,
			  const int bitmap_w, const int bitmap_h)
{
    assert(coord);
    assert(sprite);

    coord->w = sprite->w/2.0;
    coord->h = sprite->h/2.0;

    coord->top    = (GLdouble)sprite->y/bitmap_h;
    coord->bottom = (GLdouble)(sprite->y+sprite->h)/bitmap_h;

    coord->left  = (GLdouble)sprite->x/bitmap_w;
    coord->right = (GLdouble)(sprite->x+sprite->w)/bitmap_w;
}
