/* packet-starts.c,
 *
 * Convert starting location packets to/from a buffer, to be across
 * the network.
 */

#include <assert.h>
#include "network.h"
#include "packet-starts.h"


/*--------------------------------------------------------------*/

NLint packet_start_loc_encode(const struct packet_start_loc *packet,
			      NLbyte *buf, NLint buf_size)
{
    NLint count = 0;
    int xx = packet->x + zero_x;
    int yy = packet->y + zero_y;

    writeByte (buf, count, COMMAND_START_LOC);
    writeStartID(buf, count, packet->id);
    writeShort(buf, count, xx);
    writeShort(buf, count, yy);

    assert(count <= buf_size);
    return count;
}


void packet_start_loc_decode(struct packet_start_loc *packet,
			     const NLbyte *buf, const NLint buf_size)
{
    NLint count = 1;

    readStartID(buf, count, packet->id);
    readShort(buf, count, packet->x); packet->x -= zero_x;
    readShort(buf, count, packet->y); packet->y -= zero_y;

    assert(count == buf_size);
}


NLint packet_start_locs_encode(const start_loc_t *starts,
			       NLbyte *buf, NLint buf_size)
{
    NLint count = 0;
    unsigned int i;

    writeByte(buf, count, COMMAND_START_LOCS);

    for (i = 0; i < MAX_START_LOCS; i++) {
	writeByte(buf, count, starts[i].used);

	if (starts[i].used) {
	    int xx = starts[i].x + zero_x;
	    int yy = starts[i].y + zero_y;

	    writeShort(buf, count, xx);
	    writeShort(buf, count, yy);
	}
    }

    assert(count <= buf_size);
    return count;
}


void packet_start_locs_decode(start_loc_t *starts,
			      const NLbyte *buf, const NLint buf_size)
{
    NLint count = 1;
    unsigned int i;

    for (i = 0; i < MAX_START_LOCS; i++) {
	readByte(buf, count, starts[i].used);

	if (starts[i].used) {
	    readShort(buf, count, starts[i].x); starts[i].x -= zero_x;
	    readShort(buf, count, starts[i].y); starts[i].y -= zero_y;
	}
    }

    assert(count == buf_size);
}

/*--------------------------------------------------------------*/
/* Map editor only.						*/
/*--------------------------------------------------------------*/

NLint packet_start_del_encode(const struct packet_start_del *packet,
			      NLbyte *buf, NLint buf_size)
{
    NLint count = 0;

    writeStartID(buf, count, packet->id);

    assert(count <= buf_size);
    return count;
}


void packet_start_del_decode(struct packet_start_del *packet,
			     const NLbyte *buf, const NLint buf_size)
{
    NLint count = 0;

    readStartID(buf, count, packet->id);

    assert(count == buf_size);
}
