/* menu-connect.c,
 *
 * Connect to server.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>

#include "client.h"
#include "lobby.h"
#include "menu/lobby-client.h"
#include "menu/menu-connect.h"
#include "menu/menu-runner.h"
#include "menu/widget.h"
#include "network.h"
#include "strlcpy.h"


static char connect_dialog_log[256];

/*--------------------------------------------------------------*/

static int join_callback(DIALOG *_);


DIALOG connect_dialog[] = {
    /* proc, x, y, w, h, fg, bg, key, flags, d1, d2, dp1, dp2, dp3 */
    { d_ctext_proc,
      0, 50, 640, 40,
      -0xff2020, -0x000000,
      0, 0, 0, 0,
      "Connect", NULL, NULL },

    { d_ctext_proc,
      0, 350, 640, 40,
      -0xff0000, -0x000000,
      0, 0, 0, 0,
      connect_dialog_log, NULL, NULL },

    { d_rtext_proc,
      150, 150, 40, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Name: ", NULL, NULL },

    { d_edit_proc,
      190, 150, 300, 40,
      -0xffffff, -0x202020,
      0, 0, sizeof(name_buf)-1, 0,
      name_buf, NULL, NULL },

    { d_rtext_proc,
      150, 200, 40, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Host: ", NULL, NULL },

    { d_edit_proc,
      190, 200, 300, 40,
      -0xffffff, -0x202020,
      0, 0, sizeof(host_buf)-1, 0,
      host_buf, NULL, NULL },

    { d_aalg_push_proc,
      190, 300, 150, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Join", NULL, join_callback },

    { d_button_proc,
      340, 300, 150, 40,
      -0xffffff, -0x202020,
      0, D_EXIT, 0, 0,
      "Back", NULL, NULL },

    { d_algl_hack_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { d_yield_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { NULL,		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

/*--------------------------------------------------------------*/

static int join_callback(DIALOG *_)
{
    (void)_;

    client_server_mode = I_AM_CLIENT_ONLY;

    if (client_init(name_buf, host_buf)) {
	connect_dialog_log[0] = '\0';

        lobby_loop(NULL, &clobby_fe);
	clear_keybuf();

	client_shutdown();
    }
    else {
	strlcpy(connect_dialog_log, "Error initialising client.",
		sizeof(connect_dialog_log));
    }

    client_server_mode = I_AM_MENU;
    return D_O_K;
}
