/* lobby-server.c,
 *
 * The client-server lobby, slobby.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>
#include <stdio.h>

#include "client.h"
#include "lobby.h"
#include "menu/lobby-server.h"
#include "menu/widget.h"
#include "network.h"


static char map_buf[256] = "Map Name";
static char chat_prompt[256];

/*--------------------------------------------------------------*/

static void *slobby_initialise(game_state_t *state);
static bool slobby_update(void *a);
static void slobby_redraw(void);
static void slobby_shutdown(void *a);


lobby_client_fe_t slobby_fe = {
    slobby_initialise,
    slobby_update,
    slobby_redraw,
    slobby_shutdown
};

/*--------------------------------------------------------------*/

#define SLOBBY_DIALOG_DEFAULT_FOCUS	1

static int map_select_callback(DIALOG *d);
static int lister_callback(DIALOG *d, const char *str);
static int start_callback(DIALOG *_);
static int quit_callback(DIALOG *d);


DIALOG slobby_dialog[] = {
    /* proc, x, y, w, h, fg, bg, key, flags, d1, d2, dp1, dp2, dp3 */
    { d_ctext_proc,
      1, 30, -1, 40,
      -0xff2020, -0x000000,
      0, 0, 0, 0,
      "Lobby", NULL, NULL },

    { d_chat_proc,
      10, 60, -330, -110,
      -0x808080, -0x080808,
      0, 0, 0, 0,
      &slobby_dialog[2], NULL, NULL },

    { d_prompt_proc,
      10, -40, -330, 20,
      -0xffffff, -0x000040,
      0, 0, sizeof(chat_prompt)-1, 0,
      chat_prompt, NULL, NULL },

    { d_button_proc,
      -310, 60, 280, 20,
      -0xffffff, -0x202020,
      0, D_DISABLED, 0, 0,
      map_buf, NULL, NULL },

    { d_toggle_proc,
      -30, 60, 20, 20,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "_", NULL, map_select_callback },

    { d_tab_proc,
      -310, 90, 150, 30,
      -0xffffff, -0x202020,
      0, D_SELECTED, 1, WIDGET_STATS_SERVER_INFO,
      "Server info", NULL, NULL },

    { d_tab_proc,
      -160, 90, 150, 30,
      -0xffffff, -0x202020,
      0, 0, 1, WIDGET_STATS_PLAYER_INFO,
      "Player info", NULL, NULL },

    { d_stats_proc,
      -310, 120, 300, -190,
      -0xffffff, -0x202020,
      0, D_USER, 0, 0,
      slobby_dialog, NULL, NULL },

    { d_stats_client_proc,
      -310, 90, 300, -160,
      -0xffffff, -0x202020,
      0, D_DISABLED | D_HIDDEN, 0, 0,
      slobby_dialog, NULL, NULL },
    
    { d_lister_proc,
      -310, 90, 300, -160,
      -0xffffff, -0x202020,
      0, D_DISABLED | D_HIDDEN, 0, 0,
      NULL, NULL, lister_callback },

    { d_aalg_push_proc,
      -220, -60, 100, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Start", NULL, start_callback },

    { d_aalg_push_proc,
      -120, -60, 100, 40,
      -0xffffff, -0x202020,
      0, D_EXIT, 0, 0,
      "Quit", NULL, quit_callback },

    { d_algl_hack_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { d_yield_proc,	0, 0, 0, 0, 0, 0,27, 0, 0, 0, NULL, NULL, NULL },
    { NULL,		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

/*--------------------------------------------------------------*/

static int map_select_callback(DIALOG *d)
{
    DIALOG *dd;

    if (d->flags & D_SELECTED) {
	/* Show the map files. */
	for (dd = &slobby_dialog[0]; dd->proc; dd++) {
	    if ((dd->proc == d_tab_proc) ||
		(dd->proc == d_stats_proc)) {
		dd->flags |= (D_DISABLED | D_HIDDEN);
	    }
	    else if (dd->proc == d_lister_proc) {
		dd->flags &=~(D_DISABLED | D_HIDDEN);
		object_message(dd, MSG_USER, 0);
	    }
	}
    }
    else {
	/* Show the server/client info. */
	for (dd = &slobby_dialog[0]; dd->proc; dd++) {
	    if ((dd->proc == d_tab_proc) ||
		(dd->proc == d_stats_proc)) {
		dd->flags &=~(D_DISABLED | D_HIDDEN);
	    }
	    else if (dd->proc == d_lister_proc) {
		dd->flags |= (D_DISABLED | D_HIDDEN);
		object_message(dd, MSG_USER, 1);
	    }
	}
    }

    return D_O_K;
}


static int lister_callback(DIALOG *_, const char *str)
{
    char buf[MAX_PACKET_SIZE];
    (void)_;

    snprintf(buf, sizeof(buf), "map %s", str);
    client_send_command(buf);

    return D_O_K;
}


static int start_callback(DIALOG *_)
{
    (void)_;

    client_send_command("start");

    return D_O_K;
}


static int quit_callback(DIALOG *d)
{
    game_state_t *state = d->dp2;

    client_send_command("quit");
    state->context = SERVER_QUIT;

    return D_O_K;
}

/*--------------------------------------------------------------*/

static void *slobby_initialise(game_state_t *state)
{
    DIALOG_PLAYER *dialog;
    DIALOG *d;

    dialog = init_dialog(slobby_dialog, SLOBBY_DIALOG_DEFAULT_FOCUS);

    for (d = &slobby_dialog[0]; d->proc; d++) {
	/* Game state required for:
	 *  - text prompt
	 *  - server info
	 *  - quit button
	 */
	if ((d->proc == d_prompt_proc) ||
	    (d->proc == d_stats_proc) ||
	    (d->flags & D_EXIT)) {
	    d->dp2 = state;
	}
    }

    return dialog;
}


static bool slobby_update(void *a)
{
    DIALOG_PLAYER *dialog = a;
    assert(dialog);

    return update_dialog(dialog);
}


static void slobby_redraw(void)
{
    glClear(GL_COLOR_BUFFER_BIT);
    broadcast_dialog_message(MSG_DRAW, 0);
    algl_draw_mouse();
    allegro_gl_flip();
}


static void slobby_shutdown(void *a)
{
    DIALOG_PLAYER *dialog = a;
    assert(dialog);

    shutdown_dialog(dialog);
}
