/* fps.c,
 *
 * FPS counter.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>
#include <stdbool.h>

#include "common.h"
#include "fps.h"

/*--------------------------------------------------------------*/

volatile int fps_counter, last_fps;
static void fps_timer(void)
{
    last_fps = fps_counter;
    fps_counter = 0;
}
END_OF_FUNCTION(fps_timer);

/*--------------------------------------------------------------*/

static bool show_fps;


void toggle_fps(void)
{
    show_fps = !show_fps;
}


void fps_draw(void)
{
    if (show_fps) {
	glColor3fv(glWhite);
	allegro_gl_printf_ex(al_font, 5.0, 50.0, 0.0, "FPS: %d", last_fps);
    }
}

/*--------------------------------------------------------------*/

void fps_init(void)
{
    LOCK_VARIABLE(fps_counter);
    LOCK_FUNCTION(fps_timer);
    install_int_ex(fps_timer, SECS_TO_TIMER(1));
    fps_counter = 0;
}


void fps_shutdown(void)
{
    remove_int(fps_timer);
}
