/* cursor.c,
 *
 * Mouse cursor related routines.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>
#include "cursor.h"
#include "texdraw.h"


static BITMAP *bmp_cursor;
static GLuint tex_cursor;

/*--------------------------------------------------------------*/

/* cursor_draw:
 *
 * Draw a mouse cursor.  For some reason, I can't get AllegroGL's
 * "algl_draw_cursor" to work.
 */
void cursor_draw(void)
{
    const texcoord2d_t coord = {
	16.0, 16.0,
	0.0/32.0, 32.0/32.0, 0.0/32.0, 32.0/32.0
    };
    double mx =  mouse_x*640.0/SCREEN_W;
    double my = -mouse_y*480.0/SCREEN_H + 480.0-1.0;

    glPushMatrix();

    glBindTexture(GL_TEXTURE_2D, tex_cursor);
    glBegin(GL_QUADS);
    gl_draw_sprite_2d(&coord, mx-7.5, my-7.5);
    glEnd();

    glPopMatrix();
}

/*--------------------------------------------------------------*/

/* cursor_coordinates:
 *
 * Convert the allegro mouse coordinates (mx, my) to Red Pixel units:
 * (0, 0) is in the lower-left, (640, 480) is top right.  Take into
 * account scale too.
 */
void cursor_coordinates(const int mx, const int my, const double scale,
			double *nx, double *ny)
{
    *nx = mx*640.0/(SCREEN_W*scale);
    *ny = (480.0-1.0 - my*480.0/SCREEN_H)/scale;
}

/*--------------------------------------------------------------*/

void cursor_init(void)
{
    bmp_cursor = load_bitmap("data/cursor.tga", NULL);
    assert(bmp_cursor);

    tex_cursor = allegro_gl_make_texture_ex(AGL_TEXTURE_MASKED,
					    bmp_cursor, -1);
}


void cursor_shutdown(void)
{
    if (bmp_cursor) {
	destroy_bitmap(bmp_cursor);
	bmp_cursor = NULL;
    }
}
