#ifndef __included_sv_internal_h__
#define __included_sv_internal_h__

#include <stdbool.h>
#include <nl.h>
#include "player.inc"
#include "score.h"

#define MAX_CLIENTS		16
#define NUM_CLIENT_TYPES	5

enum CLIENT_TYPE {
    CLIENT_UNUSED,
    CLIENT_CONNECTING,
    CLIENT_ROBOT,
    CLIENT_GAMER,
    CLIENT_ADMIN
};

typedef struct {
    client_id clid;
    NLsocket sock;

    char name[MAX_NAME_LEN];
    enum CLIENT_TYPE type;

    int last_packet_received;	/* time */

    player_id id;
    unsigned char face_num;
    score_t sc;
} client_data_t;


extern client_data_t client_data[MAX_CLIENTS];
extern NLint group_all_clients;
extern NLint group_all_gamers;

extern const char *client_type_str(const enum CLIENT_TYPE type);
extern void sv_intern_sort_by_score(void);
extern int sv_intern_client_from_sock(const NLsocket sock);
extern int sv_intern_client_from_name(const char *name);
extern int sv_intern_client_from_client_id(const client_id id);
extern int sv_intern_client_from_id(const player_id id);
extern int sv_intern_unused_client(void);
extern bool sv_intern_set_admin(client_data_t *data);
extern bool sv_intern_set_gamer(client_data_t *data);
extern int sv_intern_open(const NLsocket sock);
extern void sv_intern_close(const NLsocket sock);
extern void sv_intern_init(void);

#endif
