#ifndef __included_stats_pickup_h__
#define __included_stats_pickup_h__

#include <stdbool.h>
#include "pickup.inc"
#include "powerup.h"
#include "sprite.h"
#include "weapon.inc"

enum PICKUP_TYPE {
    PICKUP_WEAPON,
    PICKUP_AMMO,
    PICKUP_HEALTH,
    PICKUP_POWERUP
};

typedef struct {
    int respawn_time;		/* msec */

    enum PICKUP_TYPE type;

    char symbol;

    unsigned int give_health;

    /* These *should* be in a union, but they don't initialise
       properly. */
    struct {
	struct {
	    enum WEAPON_CLASS weapon;
	    unsigned int ammo;
	} weapon;

	struct {
	    enum POWERUP_CLASS powerup;
	    unsigned int duration;
	} powerup;
    } give;
} pickup_stats_t;


extern const pickup_stats_t pickup_stats[NUM_PICKUP_CLASSES];
extern const sprite_t pickup_sprite[NUM_PICKUP_CLASSES];

extern enum PICKUP_CLASS pickup_class_from_symbol(const char symbol);
extern char pickup_class_to_symbol(const enum PICKUP_CLASS p);

#endif
