#ifndef __included_stats_particle_h__
#define __included_stats_particle_h__

#include <GL/gl.h>

#define NUM_PARTICLE_CATEGORIES	3
#define NUM_PARTICLE_CLASSES	8

enum PARTICLE_CATEGORY {
    PARTICLE_BLOOD,
    PARTICLE_RESPAWNING,
    PARTICLE_SPARK
};

enum PARTICLE_CLASS {
    PARTICLE_BLOOD1,
    PARTICLE_BLOOD2,
    PARTICLE_BLOOD3,
    PARTICLE_BLOOD4,
    PARTICLE_BLOOD5,
    PARTICLE_RESPAWNING1,
    PARTICLE_RESPAWNING2,
    PARTICLE_SPARK1
};

typedef struct {
    unsigned int num;
    enum PARTICLE_CLASS lower, upper;

    /* Lux */
    int lux_life;		/* msec */
    float lux_r;
    GLfloat lux_colour[4];
} part_cat_stats_t;

typedef struct {
    int time_rand;		/* msec */
    int life_min, life_rand;	/* msec */
    int v_min, v_rand;		/* pixels/sec */

    GLfloat colour[3];
} particle_stats_t;


extern const part_cat_stats_t particle_category[NUM_PARTICLE_CATEGORIES];
extern const particle_stats_t particle_stats[NUM_PARTICLE_CLASSES];

extern enum PARTICLE_CLASS
particle_class_from_category(const enum PARTICLE_CATEGORY cat);

#endif
