#ifndef __included_sprite_h__
#define __included_sprite_h__

#include <GL/gl.h>
#include <stdbool.h>
#include "texdraw.h"

typedef struct {
    int x, y;
    int w, h;
} sprite_t;

typedef struct {
    int x, y;
    int w, h;
    int nframes;
    int frame_time;		/* msec */
} anim_sprite_t;

typedef struct {
    int x, y;
    int w, h;
    int nframes;
    int frame_time;		/* msec */
    GLdouble pivot_x, pivot_y;
} weapon_sprite_t;


extern void sprite_tint_col(const bool highlight, const bool hidden,
			    const GLfloat **last_col);
extern void texcoord_from_sprite(texcoord2d_t *coord, const sprite_t *sprite,
				 const int bitmap_w, const int bitmap_h);

#endif
