#ifndef __included_smoke_h__
#define __included_smoke_h__

#include "smoke.inc"

typedef struct smoke {
    struct smoke *next;
    struct smoke *prev;

    enum SMOKE_CLASS class;

    /* Spawn state. */
    int _spawn_time;
    float _spawn_x, _spawn_y;
    float _spawn_vx, _spawn_vy;

    /* Current state. */
    int frame;
    float x, y;
} smoke_t;


extern void smoke_update(void);
extern void smoke_draw(void);
extern void smoke_new(const enum SMOKE_CLASS class,
		      const float x, const float y, 
		      const float vx, const float vy, const int tick);
extern void smoke_start(void);
extern void smoke_stop(void);
extern void smoke_init(void);
extern void smoke_shutdown(void);

#endif
