#ifndef __included_particle_h__
#define __included_particle_h__

#include "stats-particle.h"

#define PARTICLE_ARRAY_SIZE		8

/* Lots and lots of stats!
 *
 * parta_count	- num particle arrays in sliver->list.
 * parta_freed	- num particle arrays in 'particle_free_list'.
 * parta_total	- num allocated particle arrays.
 *
 * parte_count	- num active particles.
 * parte_steps	- num steps taken by last call to update.
 * parte_stepped- num particles stepped.
 * parte_nubbed	- num particles deleted when they where inactived.
 * parte_drawn	- num particles drawn.
 *
 * parti_count	- num particles in 'particle_inactive_list'.
 * parti_freed	- num particles in 'particle_free_list_i'.
 * parti_total	- num allocated inactive particles.
 *
 * The average load, alpha, of the particle arrays can be calculated:
 *	alpha = parte_count / (parta_count * PARTICLE_ARRAY_SIZE)
 */

extern int parta_total;
extern int parte_count;
extern int parti_total;

#ifdef DEBUG_PARTICLE_STATS
extern int parta_count, parta_freed;
extern int parte_steps, parte_stepped, parte_nubbed;
extern int parte_drawn;
extern int parti_count, parti_freed;
#endif

extern void particle_update(void);
extern void particle_draw(void);
extern void particle_new(const enum PARTICLE_CATEGORY cat,
			 const float x, const float y, const int tick);
extern void particle_new_unit(const enum PARTICLE_CLASS class,
			      const float x, const float y,
			      const float vx, const float vy, const int tick);
extern void particle_set_multiplier(const int x);
extern int particle_get_multiplier(void);
extern void particle_start(void);
extern void particle_stop(void);
extern void particle_init(void);
extern void particle_shutdown(void);

#endif
