#ifndef __included_packet_pickup_h__
#define __included_packet_pickup_h__

#include <nl.h>
#include <stdbool.h>
#include "pickup.inc"
#include "player.inc"

#define sizeof_packet_pickup_new_begin	(1+1)
#define sizeof_packet_pickup_new	(4+2+1+2+2)

struct packet_pickup_new {
    int time;

    pickup_id id;
    enum PICKUP_CLASS class;
    float x, y;
};

struct packet_pickup_quaff {
    int time;

    pickup_id id;
    player_id quaffer;
};


extern NLint
packet_pickup_new_begin_encode(const int num,
			       NLbyte *buf, const NLint sz);
extern NLint
packet_pickup_new_begin_decode(int *num,
			       const NLbyte *buf, const NLint sz);
extern NLint
packet_pickup_new_encode(const struct packet_pickup_new *packet,
			 NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_pickup_new_decode(struct packet_pickup_new *packet,
			 const NLbyte *buf, const NLint sz, NLint count);
extern NLint packet_pickup_quaff_encode(const struct packet_pickup_quaff *,
					NLbyte *buf, NLint size);
extern void packet_pickup_quaff_decode(struct packet_pickup_quaff *packet,
				       const NLbyte *buf, const NLint size);


/* Map editor only. */
struct packet_pickup_mov {
    pickup_id id;
    int x, y;
};

struct packet_pickup_del {
    pickup_id id;
};


extern NLint packet_pickup_mov_encode(const struct packet_pickup_mov *packet,
				      NLbyte *buf, NLint buf_size);
extern void packet_pickup_mov_decode(struct packet_pickup_mov *packet,
				     const NLbyte *buf, const NLint buf_size);
extern NLint packet_pickup_del_encode(const struct packet_pickup_del *packet,
				      NLbyte *buf, NLint buf_size);
extern void packet_pickup_del_decode(struct packet_pickup_del *packet,
				     const NLbyte *buf, const NLint buf_size);

#endif
