#ifndef __included_packet_map_h__
#define __included_packet_map_h__

#include <nl.h>
#include "game-state.h"
#include "map.h"

#define MAP_BLOCK_W	10
#define MAP_BLOCK_H	10

extern NLint packet_map_encode(const map_t *src, const int X0, const int Y0,
			       NLbyte *buf, NLint size);
extern void packet_map_decode(map_t *dest, const NLbyte *buf, const NLint size,
			      game_state_t *state);
extern NLint packet_set_zero_encode(const int dx, const int dy,
				    NLbyte *buf, NLint size);
extern void packet_set_zero_decode(const NLbyte *buf, const NLint size);

#endif
