#ifndef __included_packet_candela_h__
#define __included_packet_candela_h__

#include <GL/gl.h>
#include <nl.h>
#include "candela.inc"

#define CANDELA_INCLUDE_POSITION	0x01
#define CANDELA_INCLUDE_AMBIENT		0x02
#define CANDELA_INCLUDE_CUTOFF		0x10
#define CANDELA_INCLUDE_EXPONENT	0x20
#define CANDELA_INCLUDE_ALL		\
	(CANDELA_INCLUDE_POSITION	\
	|CANDELA_INCLUDE_AMBIENT	\
	|CANDELA_INCLUDE_CUTOFF		\
	|CANDELA_INCLUDE_EXPONENT)

#define sizeof_packet_candela_new_begin	(1+1)
#define sizeof_packet_candela_new	(1+1 + 2*2 + 3*1 + 1+1)

struct packet_candela_new {
    candela_id id;
    char size;

    /* Optional: */
    GLint posi[2];		/* posi[2] = 100, posi[3] = 1 */
    GLfloat ambi[3];		/* ambi[1] = 1 */
    GLfloat cutoff;
    GLint exponent;
};


extern NLint
packet_candela_new_begin_encode(const int num,
				NLbyte *buf, const NLint sz);
extern NLint
packet_candela_new_begin_decode(int *num,
				const NLbyte *buf, const NLint sz);
extern NLint
packet_candela_new_encode(const struct packet_candela_new *packet,
			  NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_candela_new_decode(struct packet_candela_new *packet,
			  const NLbyte *buf, const NLint sz, NLint count);


/* Map editor only. */
struct packet_candela_del {
    candela_id id;
};


extern NLint packet_candela_delete_encode(const struct packet_candela_del *,
					  NLbyte *buf, const NLint buf_size);
extern void packet_candela_delete_decode(struct packet_candela_del *packet,
					 const NLbyte *buf, const NLint sz);

#endif
