#ifndef __included_gizmo_h__
#define __included_gizmo_h__

#include <stdbool.h>
#include "list.h"
#include "packet-gizmo.h"
#include "player.h"

typedef struct gizmo {
    struct gizmo *next;
    struct gizmo *prev;

    gizmo_id id;
    enum GIZMO_CLASS class;

    double x, y;
    double w, h;

    bool highlight;
} gizmo_t;


extern list_head_t gizmo_list;

extern bool gizmo_in_tile(const enum GIZMO_CLASS g, const int x, const int y);
extern bool gizmo_update_with_player(player_t *p);
extern gizmo_t *player_foot_in_gizmo(const double px, const double py);
extern void gizmo_bind_texture(void);
extern void gizmo_draw(const bool editor_enabled);
extern void gizmo_draw_unit(const enum GIZMO_CLASS class,
			    const int x, const int y, const bool for_game);
extern gizmo_t *gizmo_from_id(const gizmo_id id);
extern gizmo_id gizmo_bounding(const int x, const int y);
extern enum GIZMO_CLASS gizmo_select(const int n);
extern gizmo_id gizmo_generate_unique_id(void);
extern int gizmo_total(void);
extern void gizmo_new(const struct packet_gizmo_new *packet);
extern void gizmo_move(const struct packet_gizmo_mov *packet);
extern void gizmo_shift(const double offx, const double offy);
extern void gizmo_delete(const struct packet_gizmo_del *packet);
extern void gizmo_start(void);
extern void gizmo_stop(void);
extern void gizmo_init(void);
extern void gizmo_shutdown(void);

#endif
