#ifndef __included_gettime_h__
#define __included_gettime_h__

#ifdef __unix__

#include <sys/time.h>

#define gettime_start()		/* Nothing */
#define get_time_of_day(a)	tv_get_time_of_day(a)
#define increase_time(a,b)	tv_increase_time(a,b)
#define time_between(a,b)	tv_time_between(a,b)

typedef struct timeval timeval_t;

extern void tv_get_time_of_day(struct timeval *tv);
extern void tv_increase_time(struct timeval *tv, const int duration);
extern int tv_time_between(const struct timeval *a, const struct timeval *b);

#else  /* !__unix__ */

#define gettime_start()		win_gettime_start()
#define get_time_of_day(a)	win_get_time_of_day(a)
#define increase_time(a,b)	win_increase_time(a,b)
#define time_between(a,b)	win_time_between(a,b)

typedef __int64 timeval_t;	/* counts */

extern void win_gettime_start(void);
extern void win_get_time_of_day(__int64 *tv);
extern void win_increase_time(__int64 *tv, const int duration);
extern int win_time_between(const __int64 *a, const __int64 *b);

#endif /* !__unix__ */

#endif
