#ifndef __included_candela_h__
#define __included_candela_h__

#include <GL/gl.h>
#include <stdbool.h>
#include "candela.inc"
#include "list.h"
#include "packet-candela.h"

#define CANDELA_W_2		14
#define CANDELA_H_2		15

typedef struct candela {
    struct candela *next;
    struct candela *prev;

    candela_id id;

    GLint posi[4];
    GLfloat ambi[4];
    GLfloat cutoff;
    GLint exponent;

    /* Radius of the lighted circle on the z=0 plane.  */
    double r;

    bool highlight;
} candela_t;


extern list_head_t candela_list;

extern GLenum candela_position(GLenum light);
extern void candela_draw(void);
extern void candela_draw_bulb(const int x, const int y);
extern candela_t *candela_from_id(const candela_id id);
extern candela_id candela_bounding(const int x, const int y);
extern candela_id candela_radius_bounding(const int x, const int y);
extern candela_id candela_generate_unique_id(void);
extern int candela_total(void);
extern void candela_new(const struct packet_candela_new *packet);
extern void candela_set_parameters(candela_t *c,
				   const struct packet_candela_new *packet);
extern void candela_shift(const GLint offx, const GLint offy);
extern void candela_delete(const candela_id id);
extern void candela_start(void);
extern void candela_stop(void);
extern void candela_init(void);
extern void candela_shutdown(void);

#endif
