#ifndef __included_camera_h__
#define __included_camera_h__

#include <stdbool.h>

#define CAMERA_DEFAULT_MAX_DIST		220

typedef struct {
    float x, y;
    float xv, yv;
    float push_x, push_y;
    int target_x, target_y;
    int view_width, view_height;
    bool pushable;
    int max_dist;

    float scale, desired_scale;
} camera_t;


extern camera_t camera;

extern bool camera_can_see(const camera_t *cam, const int x, const int y,
			   const int w, const int h);
extern bool camera_can_see2(const camera_t *cam, const int x, const int y,
			    const int w, const int h);
extern bool point_in_sight(const camera_t *cam, const int x, const int y);
extern bool circle_in_sight(const camera_t *cam, const int x, const int y,
			    const double r);
extern void camera_zoom(camera_t *cam);
extern void camera_track_point_with_mouse(camera_t *cam,
					  const int px, const int py,
					  const int mx, const int my);

#endif
