#ifndef __included_bullet_h__
#define __included_bullet_h__

#include <stdbool.h>
#include "container.inc"
#include "game-state.h"
#include "list.h"
#include "lux.h"
#include "packet-bullet.h"
#include "player.inc"

typedef struct bullet {
    struct bullet *next;
    struct bullet *prev;

    bullet_id id;
    enum WEAPON_CLASS class;
    player_id parent;
    double modifier;		/* Berserker or handycap. */

    /* Spawn state. */
    int _spawn_time;
    double _spawn_x, _spawn_y;
    float _spawn_angle;
    double _spawn_vx, _spawn_vy;

    /* Current state. */
    int time; 
    double x, y;
    float spin;
    int next_smoke_time;
    int grenade_life;		/* Grenades */
    int sound_source_n;		/* Missiles */

    lux_t *lux;

    container_id hurtee_container;
    player_id hurtee;
} bullet_t;


extern void bullet_update(game_state_t *state);
extern bool bullet_update_unit(bullet_t *b, const int tick,
			       const game_state_t *state);
extern void bullet_move(bullet_t *b, const int tick);
extern void bullet_draw(const game_state_t *state);
extern bullet_t *bullet_from_id(const bullet_id id, const game_state_t *state);
extern NLint bullet_encode_and_spawn(NLbyte *buf, const NLint sz,
				     game_state_t *state);
extern NLint bullet_encode_and_delete(NLbyte *buf, const NLint sz);
extern void bullet_new(const struct packet_bullet_new *packet,
		       game_state_t *state);
extern void bullet_free(bullet_t *b);
extern void bullet_start(game_state_t *state);
extern void bullet_stop(game_state_t *state);
extern void bullet_init(void);
extern void bullet_shutdown(void);

#endif
