#ifndef __included_backpack_h__
#define __included_backpack_h__

#include "backpack.inc"
#include "game-state.h"
#include "player.h"
#include "weapon.inc"

#define BACKPACK_W	(36.0/2.0)
#define BACKPACK_H	(39.0/2.0)

typedef struct backpack {
    struct backpack *next;
    struct backpack *prev;

    backpack_id id;
    player_id parent;

    /* Spawn state. */
    int _spawn_time;
    double _spawn_x, _spawn_y;
    double _spawn_vx, _spawn_vy;

    /* Current state. */
    int time;
    double x, y;

    unsigned int weapon_ammo[NUM_WEAPON_CLASSES];

    player_t *taker;
} backpack_t;


extern list_head_t backpack_list;

extern void backpack_update(game_state_t *state);
extern void backpack_draw(const game_state_t *state);
extern backpack_t *backpack_from_id(const backpack_id id,
				    const game_state_t *state);
extern backpack_id backpack_generate_unique_id(void);
extern backpack_t *backpack_new(const struct packet_player_die *packet,
				game_state_t *state);
extern void backpack_new2(const struct packet_player_die *packet,
			  const player_t *p, game_state_t *state);
extern void backpack_free(backpack_t *b);
extern void backpack_start(game_state_t *state);
extern void backpack_stop(game_state_t *state);
extern void backpack_init(void);
extern void backpack_shutdown(void);

#endif
