/* packet-bullet.c,
 *
 * Convert bullet command packets to/from a buffer, to be sent across
 * the network.
 */

#include <assert.h>
#include "network.h"
#include "packet-bullet.h"


/*--------------------------------------------------------------*/

NLint packet_bullet_new_begin_encode(const int num,
				     NLbyte *buf, const NLint sz)
{
    NLint count = 0;

    writeByte(buf, count, COMMAND_BULLET_NEW);
    writeByte(buf, count, num);

    assert(count <= sz);
    return count;
}


NLint packet_bullet_new_begin_decode(int *num,
				     const NLbyte *buf, const NLint sz)
{
    NLint count = 1;
    int n;

    readByte(buf, count, n); *num = n;

    assert(count <= sz);
    return count;
}


NLint packet_bullet_new_encode(const struct packet_bullet_new *packet,
			       NLbyte *buf, const NLint sz, NLint count)
{
    float xx = packet->x + zero_x;
    float yy = packet->y + zero_y;

    writeLong (buf, count, packet->time);
    writeBulletID(buf, count, packet->id);
    writeWeaponClass(buf, count, packet->class);
    writePlayerID(buf, count, packet->parent);
    writeFloat(buf, count, xx);
    writeFloat(buf, count, yy);
    writeFloat(buf, count, packet->angle);

    assert(count <= sz);
    return count;
}


NLint packet_bullet_new_decode(struct packet_bullet_new *packet,
			       const NLbyte *buf, const NLint sz, NLint count)
{
    readLong (buf, count, packet->time);
    readBulletID(buf, count, packet->id);
    readWeaponClass(buf, count, packet->class);
    readPlayerID(buf, count, packet->parent);
    readFloat(buf, count, packet->x); packet->x -= zero_x;
    readFloat(buf, count, packet->y); packet->y -= zero_y;
    readFloat(buf, count, packet->angle);

    packet->modifier = 1.0;

    assert(count <= sz);
    return count;
}

/*--------------------------------------------------------------*/

NLint packet_bullet_die_begin_encode(const int num,
				     NLbyte *buf, const NLint sz)
{
    NLint count = 0;

    writeByte(buf, count, COMMAND_BULLET_DIE);
    writeByte(buf, count, num);

    assert(count <= sz);
    return count;
}


NLint packet_bullet_die_begin_decode(int *num,
				     const NLbyte *buf, const NLint sz)
{
    NLint count = 1;
    int n;

    readByte(buf, count, n); *num = n;

    assert(count <= sz);
    return count;
}


NLint packet_bullet_die_encode(const struct packet_bullet_die *packet,
			       NLbyte *buf, const NLint sz, NLint count)
{
    writeLong (buf, count, packet->time);
    writeBulletID(buf, count, packet->id);
    writeByte (buf, count, packet->particles);

    assert(count <= sz);
    return count;
}


NLint packet_bullet_die_decode(struct packet_bullet_die *packet,
			       const NLbyte *buf, const NLint sz, NLint count)
{
    readLong (buf, count, packet->time);
    readBulletID(buf, count, packet->id);
    readByte (buf, count, packet->particles);

    assert(count <= sz);
    return count;
}
