/* network.c,
 *
 * Some network stuff common to both server and client.
 */

#include <nl.h>
#include <stdio.h>
#include "network.h"


enum CLIENT_SERVER_MODE client_server_mode = I_AM_MENU;

/* These are the displacements of the origin of the server relative to
 * the client.
 */
int zero_tx, zero_ty;
double zero_x, zero_y;

/*--------------------------------------------------------------*/

void network_print_error(const char *module, const int ln)
{
    NLenum err = nlGetError();
    
    if (err == NL_SYSTEM_ERROR) {
        fprintf(stderr, "[%s ln.%d] System error: %s\n",
		module, ln, nlGetSystemErrorStr(nlGetSystemError()));
    }
    else {
        fprintf(stderr, "[%s ln.%d] HawkNL error: %s\n",
		module, ln, nlGetErrorStr(err));
    }
}

/*--------------------------------------------------------------*/

bool network_init(void)
{
    if (nlInit() != NL_TRUE)
	return false;

    if (nlSelectNetwork(NL_IP) != NL_TRUE)
	return false;

    return true;
}


void network_shutdown(void)
{
    fprintf(stdout, "[Network] %d open sockets\n",
	    (int)nlGetInteger(NL_OPEN_SOCKETS));

    nlShutdown();
}
