/* menu-runner.c,
 *
 * Initialise and run menus.
 */

#include <alleggl.h>
#include <assert.h>
#include <stdbool.h>

#include "config.h"
#include "maxmin.h"
#include "menu/lobby-client.h"
#include "menu/lobby-server.h"
#include "menu/menu-connect.h"
#include "menu/menu-create.h"
#include "menu/menu-play.h"
#include "menu/menu-root.h"
#include "menu/menu-runner.h"
#include "menu/widget.h"


BITMAP *menu_data;
char name_buf[32] = "Gutless";
char host_buf[256] = "localhost";
char port_buf[8] = "25000";

/*--------------------------------------------------------------*/

bool menu_loop(void)
{
    if (!menu_init())
	return false;

    algl_do_dialog_nested(root_dialog, 1);

    config_save();
    menu_shutdown();
    return true;
}

/*--------------------------------------------------------------*/

static int maybe_wrap_ordinate(int u, const int dim)
{
    if (u < 0)
	u += dim;

    assert((0 <= u) && (u <= dim));
    return u;
}


static int colour_from_hex(const int neg_hex)
{
    int hex = -neg_hex;
    int r = (hex>>16) & 0xff;
    int g = (hex>>8) & 0xff;
    int b = (hex) & 0xff;

    return makecol(r, g, b);
}


static void fixup_dialog(DIALOG *d)
{
    int screen_w = maxi(SCREEN_W, 640);
    int screen_h = maxi(SCREEN_H, 480);

    while (d->proc) {
	d->x = maybe_wrap_ordinate(d->x, screen_w);
	d->y = maybe_wrap_ordinate(d->y, screen_h);
	d->w = maybe_wrap_ordinate(d->w, screen_w);
	d->h = maybe_wrap_ordinate(d->h, screen_h);

	if (d->fg < 0)
	    d->fg = colour_from_hex(d->fg);

	if (d->bg < 0) 
	    d->bg = colour_from_hex(d->bg);

	d++;
    }
}


bool menu_init(void)
{
    int cx, cy;
    menu_data = load_bitmap("data/menu.tga", NULL);
    assert(menu_data);

    fixup_dialog(root_dialog);
    fixup_dialog(play_dialog);
    fixup_dialog(create_dialog);
    fixup_dialog(connect_dialog);
    fixup_dialog(slobby_dialog);
    fixup_dialog(clobby_dialog);

    cx = (SCREEN_W-640)/2;
    cy = (SCREEN_H-480)/2;
    position_dialog(root_dialog, cx, cy);
    position_dialog(play_dialog, cx, cy);
    position_dialog(create_dialog, cx, cy);
    position_dialog(connect_dialog, cx, cy);

    allegro_gl_set_allegro_mode();
    show_mouse(screen);
    return true;
}


void menu_shutdown(void)
{
    if (menu_data) {
	destroy_bitmap(menu_data);
	menu_data = NULL;
    }

    allegro_gl_unset_allegro_mode();
}
