/* menu-play.c,
 *
 * Multiplayer sub-menu.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>

#include "menu/menu-connect.h"
#include "menu/menu-create.h"
#include "menu/menu-play.h"
#include "menu/widget.h"

/*--------------------------------------------------------------*/

static int client_server_callback(DIALOG *_);
static int client_only_callback(DIALOG *_);


DIALOG play_dialog[] = {
    /* proc, x, y, w, h, fg, bg, key, flags, d1, d2, dp1, dp2, dp3 */
    { d_ctext_proc,
      0, 50, 640, 40,
      -0xff2020, -0x000000,
      0, 0, 0, 0,
      "Multiplayer", NULL, NULL },

    { d_aalg_push_proc,
      150, 150, 340, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Client-Server", NULL, client_server_callback },

    { d_aalg_push_proc,
      150, 200, 340, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Client", NULL, client_only_callback },

    { d_button_proc,
      150, 300, 340, 40,
      -0xffffff, -0x202020,
      0, D_EXIT, 0, 0,
      "Back", NULL, NULL },

    { d_algl_hack_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { d_yield_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { NULL,		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

/*--------------------------------------------------------------*/

static int client_server_callback(DIALOG *_)
{
    (void)_;

    algl_do_dialog_nested(create_dialog, CREATE_DIALOG_DEFAULT_FOCUS);

    return D_O_K;
}


static int client_only_callback(DIALOG *_)
{
    (void)_;

    algl_do_dialog_nested(connect_dialog, CONNECT_DIALOG_DEFAULT_FOCUS);

    return D_O_K;
}
