/* menu-create.c,
 *
 * Create a new server.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>
#include <stdio.h>

#include "client.h"
#include "coro.h"
#include "menu/lobby-server.h"
#include "menu/menu-create.h"
#include "menu/menu-runner.h"
#include "menu/widget.h"
#include "lobby.h"
#include "network.h"
#include "server.h"
#include "strlcpy.h"


static char create_dialog_log[256];

/*--------------------------------------------------------------*/

static int default_callback(DIALOG *_);
static int create_callback(DIALOG *_);


DIALOG create_dialog[] = {
    /* proc, x, y, w, h, fg, bg, key, flags, d1, d2, dp1, dp2, dp3 */
    { d_ctext_proc,
      0, 50, 640, 40,
      -0xff2020, -0x000000,
      0, 0, 0, 0,
      "Create A Server", NULL, NULL },

    { d_ctext_proc,
      0, 350, 640, 40,
      -0xff0000, -0x000000,
      0, 0, 0, 0,
      create_dialog_log, NULL, NULL },

    { d_rtext_proc,
      150, 150, 40, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Name: ", NULL, NULL },

    { d_edit_proc,
      190, 150, 300, 40,
      -0xffffff, -0x202020,
      0, 0, sizeof(name_buf)-1, 0,
      name_buf, NULL, NULL },

    { d_rtext_proc,
      150, 200, 40, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Port: ", NULL, NULL },

    { d_edit_proc,
      190, 200, 200, 40,
      -0xffffff, -0x202020,
      0, 0, sizeof(port_buf)-1, 0,
      port_buf, NULL, NULL },

    { d_aalg_push_proc,
      390, 200, 100, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Default", NULL, default_callback },

    { d_aalg_push_proc,
      190, 300, 150, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Start New Server", NULL, create_callback },

    { d_button_proc,
      340, 300, 150, 40,
      -0xffffff, -0x202020,
      0, D_EXIT, 0, 0,
      "Back", NULL, NULL },

    { d_algl_hack_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { d_yield_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { NULL,		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

/*--------------------------------------------------------------*/

static int default_callback(DIALOG *_)
{
    (void)_;

    strlcpy(port_buf, "25000", sizeof(port_buf));

    return D_O_K;
}


static int create_callback(DIALOG *_)
{
    char localhost_port[32];
    coro_t tid_server;
    coro_t tid_client;
    int port = atoi(port_buf);
    (void)_;

    client_server_mode = I_AM_CLIENT_SERVER;

    if (!server_init(port)) {
	client_server_mode = I_AM_MENU;
	strlcpy(create_dialog_log, "Error creating server.",
		sizeof(create_dialog_log));
	return D_O_K;
    }

    tid_client = coro_self();
    tid_server = coro_spawn(lobby_server_loop, tid_client);

    snprintf(localhost_port, sizeof(localhost_port), "localhost:%d", port);
    if (client_init(name_buf, localhost_port)) {
	create_dialog_log[0] = '\0';

	lobby_loop(tid_server, &slobby_fe);
	clear_keybuf();

	client_shutdown();
    }
    else {
	strlcpy(create_dialog_log, "Error initialising client.",
		sizeof(create_dialog_log));
    }

    coro_join(tid_server);
    server_shutdown();

    client_server_mode = I_AM_MENU;
    return D_O_K;
}
