/* lobby-client.c,
 *
 * The client lobby, clobby.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>

#include "lobby.h"
#include "menu/lobby-client.h"
#include "menu/widget.h"


static char map_buf[256] = "Map Name";
static char chat_prompt[256];

/*--------------------------------------------------------------*/

static void *clobby_initialise(game_state_t *state);
static bool clobby_update(void *a);
static void clobby_redraw(void);
static void clobby_shutdown(void *a);


lobby_client_fe_t clobby_fe = {
    clobby_initialise,
    clobby_update,
    clobby_redraw,
    clobby_shutdown
};

/*--------------------------------------------------------------*/

#define CLOBBY_DIALOG_DEFAULT_FOCUS	1


DIALOG clobby_dialog[] = {
    /* proc, x, y, w, h, fg, bg, key, flags, d1, d2, dp1, dp2, dp3 */
    { d_ctext_proc,
      1, 30, -1, 40,
      -0xff2020, -0x000000,
      0, 0, 0, 0,
      "Lobby", NULL, NULL },

    { d_chat_proc,
      10, 60, -330, -110,
      -0x808080, -0x080808,
      0, 0, 0, 0,
      &clobby_dialog[2], NULL, NULL },

    { d_prompt_proc,
      10, -40, -330, 20,
      -0xffffff, -0x000040,
      0, 0, sizeof(chat_prompt)-1, 0,
      chat_prompt, NULL, NULL },

    { d_button_proc,
      -310, 60, 300, 20,
      -0xffffff, -0x202020,
      0, D_DISABLED, 0, 0,
      map_buf, NULL, NULL },

    { d_tab_proc,
      -310, 90, 150, 30,
      -0xffffff, -0x202020,
      0, D_SELECTED, 1, WIDGET_STATS_SERVER_INFO,
      "Server info", NULL, NULL },

    { d_tab_proc,
      -160, 90, 150, 30,
      -0xffffff, -0x202020,
      0, 0, 1, WIDGET_STATS_PLAYER_INFO,
      "Player info", NULL, NULL },

    { d_stats_proc,
      -310, 120, 300, -190,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      clobby_dialog, NULL, NULL },

    { d_stats_client_proc,
      -310, 90, 300, -160,
      -0xffffff, -0x202020,
      0, D_DISABLED | D_HIDDEN, 0, 0,
      clobby_dialog, NULL, NULL },

    { d_button_proc,
      -120, -60, 100, 40,
      -0xffffff, -0x202020,
      0, D_EXIT, 0, 0,
      "Disconnect", NULL, NULL },

    { d_algl_hack_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { d_yield_proc,	0, 0, 0, 0, 0, 0,27, 0, 0, 0, NULL, NULL, NULL },
    { NULL,		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

/*--------------------------------------------------------------*/

static void *clobby_initialise(game_state_t *state)
{
    DIALOG_PLAYER *dialog;
    DIALOG *d;

    dialog = init_dialog(clobby_dialog, CLOBBY_DIALOG_DEFAULT_FOCUS);

    for (d = &clobby_dialog[0]; d->proc; d++) {
	if (d->proc == d_stats_proc)
	    d->dp2 = state;
    }

    return dialog;
}


static bool clobby_update(void *a)
{
    DIALOG_PLAYER *dialog = a;
    assert(dialog);

    return update_dialog(dialog);
}


static void clobby_redraw(void)
{
    glClear(GL_COLOR_BUFFER_BIT);
    broadcast_dialog_message(MSG_DRAW, 0);
    algl_draw_mouse();
    allegro_gl_flip();
}


static void clobby_shutdown(void *a)
{
    DIALOG_PLAYER *dialog = a;
    assert(dialog);

    shutdown_dialog(dialog);
}
