/* loft.c,
 *
 * The formula have been worked through in docs/grenade.tex.  Hmm,
 * literate Haskell would have been useful.
 */

#include <assert.h>
#include <math.h>
#include "loft.h"


/*--------------------------------------------------------------*/

bool loft_find_times(const loft_parameters_t *loft,
		     double *t_direct, double *t_indirect)
{
    double a, b, c;
    double det, sqrt_det, tt;
    assert(loft);
    assert(t_direct);
    assert(t_indirect);

    /* Here we are just about to apply the quadratic equation. */
    a = (loft->ay)*(loft->ay)/4.0;
    b =-(loft->ay)*(loft->dy) - (loft->v)*(loft->v);
    c = (loft->dx)*(loft->dx) + (loft->dy)*(loft->dy);

    det = b*b - 4*a*c;
    if (det >= 0.0) {
	sqrt_det = sqrt(det);

	tt = (-b - sqrt_det)/(2.0*a);
	*t_direct = sqrt(tt);
	assert(tt > 0.0);

	tt = (-b + sqrt_det)/(2.0*a);
	assert(tt > 0.0);
	*t_indirect = sqrt(tt);

	return true;
    }
    else {
	*t_direct = 0.0;
	*t_indirect = 0.0;
	return false;
    }
}


double loft_find_angle(const loft_parameters_t *loft, const double t)
{
    assert(loft);
    return atan2((loft->dy - loft->ay*t*t/2.0), loft->dx);
}
