/* config.c,
 *
 * Config file loading and saving.
 */

#include <allegro.h>
#include <assert.h>
#include <stdio.h>

#include "common.h"
#include "config.h"
#include "maxmin.h"
#include "menu/menu-runner.h"
#include "particle.h"
#include "sound.h"
#include "strlcpy.h"


#ifdef __unix__
# define CONFIG_FILE		".redpixelrc"
#else  /* !__unix__ */
# define CONFIG_FILE		"redpixel.cfg"
#endif /* !__unix__ */
#define SECTION			"redpixel3"

/*--------------------------------------------------------------*/

void config_set_file(void)
{
    char *home_dir = getenv("HOME");
    char config_path[PATH_MAX] = CONFIG_FILE;

    /* Config file */
    if (home_dir) {
	snprintf(config_path, sizeof(config_path), "%s/%s",
		 home_dir, CONFIG_FILE);
    }

    set_config_file(config_path);
}


void config_load(int *screen_w, int *screen_h)
{
    char *name_def;
    const char *name;
    const char *host;
    const char *port;
    int w, h;

#ifdef __unix__
    name_def = getenv("LOGNAME");
    if (!name_def) {
	name_def = getenv("USER");
    }
#else  /* !__unix__ */
    name_def = getenv("USERNAME");
#endif /* !__unix__ */

    if (!name_def)
	name_def = "Gutless";

    name = get_config_string(SECTION, "name", name_def);
    host = get_config_string(SECTION, "host", "localhost");
    port = get_config_string(SECTION, "port", "25000");

    strlcpy(name_buf, name, sizeof(name_buf));
    strlcpy(host_buf, host, sizeof(host_buf));
    strlcpy(port_buf, port, sizeof(port_buf));

    w = get_config_int(SECTION, "screen-w", *screen_w);
    h = get_config_int(SECTION, "screen-h", *screen_h);
    gl_reverse_subtract =
	!get_config_int(SECTION, "disable-reverse-subtract", 0);

    *screen_w = maxi(640, w);
    *screen_h = maxi(480, h);

    sound_set_volume(get_config_int(SECTION, "sound-volume", 128));
    reverse_stereo = get_config_int(SECTION, "reverse-stereo", 0);

    particle_set_multiplier(get_config_int(SECTION, "particles", 100));
}


void config_save(void)
{
    set_config_string(SECTION, "name", name_buf);
    set_config_string(SECTION, "host", host_buf);
    set_config_string(SECTION, "port", port_buf);

    set_config_int(SECTION, "screen-w", SCREEN_W);
    set_config_int(SECTION, "screen-h", SCREEN_H);
    set_config_int(SECTION, "disable-reverse-subtract", !gl_reverse_subtract);

    set_config_int(SECTION, "sound-volume", sound_get_volume());
    set_config_int(SECTION, "reverse-stereo", reverse_stereo);

    set_config_int(SECTION, "particles", particle_get_multiplier());
}
