#ifndef __included_weapon_h__
#define __included_weapon_h__

#include <stdbool.h>
#include "smoke.inc"
#include "sprite.h"
#include "weapon.inc"

typedef struct {
    int damage;
    double speed;		/* pixels/sec */
    double firing_rate;		/* shots/sec */

    int spray;			/* milli-degrees */
    double gun_x, gun_y;	/* barrel location relative to arm. */

    int mass;			/* percentage of velocity transferred */

    float trail_len;		/* length of bullet trails */

    struct {
	bool explosive;
	double size;
	double damage;
	enum SMOKE_CLASS boom;
    } explosion;

    struct {
	bool smokey;
	enum SMOKE_CLASS class;
	int delay;		/* msec */
    } smoke;
} weapon_t;


extern const weapon_t weapon[NUM_WEAPON_CLASSES];
extern const weapon_sprite_t weapon_sprite[NUM_WEAPON_CLASSES];
extern const sprite_t bullet_sprite[NUM_WEAPON_CLASSES];

extern bool weapon_is_automatic(const enum WEAPON_CLASS w);
extern bool weapon_is_explosive(const enum WEAPON_CLASS w);
extern bool weapon_is_smokey(const enum WEAPON_CLASS w);
extern void weapon_barrel_displacement(const enum WEAPON_CLASS w,
				       const bool mirror, const double angle,
				       double *rx, double *ry);

#endif
