#ifndef __included_texdraw_h__
#define __included_texdraw_h__

#include <GL/gl.h>

typedef struct {
    GLdouble w, h;

    GLdouble top;
    GLdouble bottom;
    GLdouble left;
    GLdouble right;
} texcoord2d_t;


extern void gl_draw_sprite_2d(const texcoord2d_t *texcoord,
			      const GLdouble X0, const GLdouble Y0);
extern void gl_draw_sprite_hflip_2d(const texcoord2d_t *texcoord,
				    const GLdouble X0, const GLdouble Y0);
extern void gl_draw_sprite_2dx(const texcoord2d_t *texcoord,
			       const GLdouble X0, const GLdouble Y0);
extern void gl_draw_sprite_hflip_2dx(const texcoord2d_t *texcoord,
				     const GLdouble X0, const GLdouble Y0);

#endif
