#ifndef __included_stats_container_h__
#define __included_stats_container_h__

#include <stdbool.h>
#include "container.inc"
#include "meat.inc"
#include "smoke.inc"
#include "sprite.h"

typedef struct {
    char symbol;

    int respawn_time;
    int health;

    struct {
	bool explosive;
	double size;
	double damage;
    } explosion;

    enum MEAT_CATEGORY meat;
    enum SMOKE_CLASS boom;
} container_stats_t;

extern const container_stats_t container_stats[NUM_CONTAINER_CLASSES];
extern const sprite_t container_sprite[NUM_CONTAINER_CLASSES];

extern enum CONTAINER_CLASS container_class_from_symbol(const char symbol);
extern char container_class_to_symbol(const enum CONTAINER_CLASS c);
extern bool container_is_explosive(const enum CONTAINER_CLASS c);

#endif
