#ifndef __included_start_loc_h__
#define __included_start_loc_h__

#include <stdbool.h>
#include "packet-starts.h"
#include "start-loc.inc"

/* This is the sprite to use when we are teleporting the player in the
   map editor, using the middle mouse button. */
#define START_LOC_TELEPORT	1

extern start_loc_t starts[MAX_START_LOCS];

extern void start_loc_set(const struct packet_start_loc *packet);
extern void start_loc_unset(const struct packet_start_del *packet);
extern void start_loc_get(const start_loc_id id, double *x, double *y);
extern start_loc_id start_loc_get_bounding(const int x, const int y);
extern start_loc_id start_loc_rand(void);
extern void start_loc_bind_texture(void);
extern void start_loc_draw(void);
extern void start_loc_draw_unit(const int nth, const int x, const int y);
extern unsigned int start_loc_total(void);
extern start_loc_id start_loc_find_unused(void);
extern void start_loc_shift(const int offx, const int offy);
extern void start_loc_start(void);
extern void start_loc_stop(void);
extern void start_loc_init(void);
extern void start_loc_shutdown(void);

#endif
