#ifndef __included_pickup_h__
#define __included_pickup_h__

#include <stdbool.h>
#include "game-state.h"
#include "list.h"
#include "packet-pickup.h"
#include "player.h"

typedef struct pickup {
    struct pickup *next;
    struct pickup *prev;

    pickup_id id;
    enum PICKUP_CLASS class;

    bool hidden;
    double x, y;
    int respawn_time;

    bool highlight;
} pickup_t;


extern list_head_t pickup_list;

extern void pickup_update(game_state_t *state);
extern void pickup_quaff_by(pickup_t *p, player_t *q, const int tick);
extern void pickup_bind_texture(void);
extern void pickup_draw(const bool editor_enabled);
extern void pickup_draw_unit(enum PICKUP_CLASS class, const int x, const int y,
			     const bool for_hud);
extern pickup_t *pickup_from_id(const pickup_id id);
extern pickup_id pickup_bounding(const int x, const int y);
extern enum PICKUP_CLASS pickup_select(const int n);
extern pickup_id pickup_generate_unique_id(void);
extern int pickup_total(void);
extern void pickup_new(const struct packet_pickup_new *packet);
extern void pickup_move(const struct packet_pickup_mov *packet);
extern void pickup_shift(const double offx, const double offy);
extern void pickup_delete(const struct packet_pickup_del *packet);
extern void pickup_start(void);
extern void pickup_stop(void);
extern void pickup_init(void);
extern void pickup_shutdown(void);

#endif
