#ifndef __included_packet_starts_h__
#define __included_packet_starts_h__

#include <nl.h>
#include "start-loc.inc"

struct packet_start_loc {
    start_loc_id id;
    int x, y;
};


extern NLint packet_start_loc_encode(const struct packet_start_loc *packet,
				     NLbyte *buf, NLint buf_size);
extern void packet_start_loc_decode(struct packet_start_loc *packet,
				    const NLbyte *buf, const NLint buf_size);
extern NLint packet_start_locs_encode(const start_loc_t starts[MAX_START_LOCS],
				      NLbyte *buf, NLint buf_size);
extern void packet_start_locs_decode(start_loc_t starts[MAX_START_LOCS],
				     const NLbyte *buf, const NLint buf_size);


/* Map editor only. */
struct packet_start_del {
    start_loc_id id;
};


extern NLint packet_start_del_encode(const struct packet_start_del *packet,
				     NLbyte *buf, NLint buf_size);
extern void packet_start_del_decode(struct packet_start_del *packet,
				    const NLbyte *buf, const NLint buf_size);

#endif
