#ifndef __included_packet_explosion_h__
#define __included_packet_explosion_h__

#include <nl.h>
#include "explosion.inc"

struct packet_explosion_new {
    int time;

    explosion_id id;
    float x, y;
    float max_r;

    /* Not sent: */
    double damage;
    double modifier;
};

struct packet_explosion_die {
    explosion_id id;
};


extern NLint packet_explosion_new_encode(const struct packet_explosion_new *,
					 NLbyte *buf, NLint size);
extern void packet_explosion_new_decode(struct packet_explosion_new *packet,
					const NLbyte *buf, const NLint size);
extern NLint packet_explosion_die_encode(const struct packet_explosion_die *,
					 NLbyte *buf, NLint size);
extern void packet_explosion_die_decode(struct packet_explosion_die *packet,
					const NLbyte *buf, const NLint size);

#endif
