#ifndef __included_packet_container_h__
#define __included_packet_container_h__

#include <nl.h>
#include <stdbool.h>
#include "container.inc"

#define sizeof_packet_container_new_begin	(1+1)
#define sizeof_packet_container_new		(2+1+2+2+1)

struct packet_container_new {
    container_id id;
    enum CONTAINER_CLASS class;
    double x, y;
    bool hidden;
};

struct packet_container_show {
    container_id id;
};

struct packet_container_hide {
    int time;

    container_id id;
};


extern NLint
packet_container_new_begin_encode(const int num,
				  NLbyte *buf, const NLint sz);
extern NLint
packet_container_new_begin_decode(int *num,
				  const NLbyte *buf, const NLint sz);
extern NLint
packet_container_new_encode(const struct packet_container_new *packet,
			    NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_container_new_decode(struct packet_container_new *packet,
			    const NLbyte *buf, const NLint sz, NLint count);
extern NLint packet_container_show_encode(const struct packet_container_show *,
					  NLbyte *buf, NLint size);
extern void packet_container_show_decode(struct packet_container_show *packet,
					 const NLbyte *buf, const NLint size);
extern NLint packet_container_hide_encode(const struct packet_container_hide *,
					  NLbyte *buf, NLint size);
extern void packet_container_hide_decode(struct packet_container_hide *packet,
					 const NLbyte *buf, const NLint size);


/* Map editor only. */
struct packet_container_mov {
    container_id id;
    double x, y;
};

struct packet_container_del {
    container_id id;
};


extern NLint packet_container_mov_encode(const struct packet_container_mov *,
					 NLbyte *buf, NLint size);
extern void packet_container_mov_decode(struct packet_container_mov *packet,
					const NLbyte *buf, const NLint size);
extern NLint packet_container_del_encode(const struct packet_container_del *,
					 NLbyte *buf, NLint size);
extern void packet_container_del_decode(struct packet_container_del *packet,
					const NLbyte *buf, const NLint size);

#endif
