#ifndef __included_packet_bullet_h__
#define __included_packet_bullet_h__

#include <nl.h>
#include "bullet.inc"
#include "player.inc"
#include "stats-particle.h"
#include "weapon.inc"

#define sizeof_packet_bullet_new_begin	(1+1)
#define sizeof_packet_bullet_new	(4+2+1+1+4+4+4)

struct packet_bullet_new {
    int time;

    bullet_id id;
    enum WEAPON_CLASS class;
    player_id parent;
    float x, y;
    float angle;

    /* Not sent: */
    double modifier;
};

#define sizeof_packet_bullet_die_begin	(1+1)
#define sizeof_packet_bullet_die	(4+2+1)

struct packet_bullet_die {
    int time;

    bullet_id id;
    enum PARTICLE_CATEGORY particles;
};


extern NLint
packet_bullet_new_begin_encode(const int num,
			       NLbyte *buf, const NLint sz);
extern NLint
packet_bullet_new_begin_decode(int *num,
			       const NLbyte *buf, const NLint sz);
extern NLint
packet_bullet_new_encode(const struct packet_bullet_new *packet,
			 NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_bullet_new_decode(struct packet_bullet_new *packet,
			 const NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_bullet_die_begin_encode(const int num,
			       NLbyte *buf, const NLint sz);
extern NLint
packet_bullet_die_begin_decode(int *num,
			       const NLbyte *buf, const NLint sz);
extern NLint
packet_bullet_die_encode(const struct packet_bullet_die *packet,
			 NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_bullet_die_decode(struct packet_bullet_die *packet,
			 const NLbyte *buf, const NLint sz, NLint count);

#endif
